package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdColorMapper;
import com.ximai.mes.md.domain.MdColor;
import com.ximai.mes.md.service.IMdColorService;

/**
 * 颜色主数据Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class MdColorServiceImpl implements IMdColorService
{
    @Autowired
    private MdColorMapper mdColorMapper;

    /**
     * 查询颜色主数据
     *
     * @param colorId 颜色主数据主键
     * @return 颜色主数据
     */
    @Override
    public MdColor selectMdColorByColorId(Long colorId)
    {
        return mdColorMapper.selectMdColorByColorId(colorId);
    }

    /**
     * 查询颜色主数据列表
     *
     * @param mdColor 颜色主数据
     * @return 颜色主数据
     */
    @Override
    public List<MdColor> selectMdColorList(MdColor mdColor)
    {
        return mdColorMapper.selectMdColorList(mdColor);
    }

    /**
     * 新增颜色主数据
     *
     * @param mdColor 颜色主数据
     * @return 结果
     */
    @Override
    public int insertMdColor(MdColor mdColor)
    {
        return mdColorMapper.insertMdColor(mdColor);
    }

    /**
     * 修改颜色主数据
     *
     * @param mdColor 颜色主数据
     * @return 结果
     */
    @Override
    public int updateMdColor(MdColor mdColor)
    {
        return mdColorMapper.updateMdColor(mdColor);
    }

    /**
     * 批量删除颜色主数据
     *
     * @param colorIds 需要删除的颜色主数据主键
     * @return 结果
     */
    @Override
    public int deleteMdColorByColorIds(Long[] colorIds)
    {
        return mdColorMapper.deleteMdColorByColorIds(colorIds);
    }

    /**
     * 删除颜色主数据信息
     *
     * @param colorId 颜色主数据主键
     * @return 结果
     */
    @Override
    public int deleteMdColorByColorId(Long colorId)
    {
        return mdColorMapper.deleteMdColorByColorId(colorId);
    }
}
