package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum TmToolStatusEnum {

    STORE("STORE", "正常入库"),
    SCRAP("SCRAP", "报废入库"),
    ISSUE("ISSUE", ""),
    REPARE("REPARE", "");


    /**
     * Lock type
     */
    private final String status;
    private final String value;

    TmToolStatusEnum(String status, String value) {
        this.status = status;
        this.value = value;
    }

    public String getStatus() {
        return status;
    }

    public String getValue() {
        return value;
    }


    public static TmToolStatusEnum get(String value) {
        for (TmToolStatusEnum temp : TmToolStatusEnum.values()) {
            if (temp.getValue().equals(value)) {
                return temp;
            }
        }
        throw new RuntimeException("异常工具状态");
    }
}
