package com.ximai.system.service;

import com.ximai.system.domain.SysApiLog;

import java.util.List;

/**
 * 操作日志 服务层
 */
public interface ISysApiLogService {
    /**
     * 新增操作日志
     *
     * @param apiLog 操作日志对象
     */
    void insertApiLog(SysApiLog apiLog);

    /**
     * 查询系统操作日志集合
     *
     * @param apiLog 操作日志对象
     * @return 操作日志集合
     */
    List<SysApiLog> selectApiLogList(SysApiLog apiLog);

    /**
     * 批量删除系统操作日志
     *
     * @param operIds 需要删除的操作日志ID
     * @return 结果
     */
    int deleteApiLogByIds(Long[] operIds);

    /**
     * 查询操作日志详细
     *
     * @param operId 操作ID
     * @return 操作日志对象
     */
    SysApiLog selectApiLogById(Long operId);

    /**
     * 清空操作日志
     */
    void cleanApiLog();

    /**
     * 执行日志记录相关操作
     * @param logIds
     * @throws Exception
     */
    void executeByIds(Long[] logIds) throws Exception;
}
