package com.ximai.mes.tm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.constant.TmToolStatusEnum;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.sap.SAPDtoTmToolBody;
import com.ximai.mes.tm.domain.TmTool;
import com.ximai.mes.tm.mapper.TmToolMapper;
import com.ximai.mes.tm.service.ITmToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 工装夹具清单Service业务层处理
 *
 * @date 2022-05-11
 */
@Service
public class TmToolServiceImpl implements ITmToolService {
    @Autowired
    private TmToolMapper tmToolMapper;

    @Autowired
    private MdItemMapper mdItemMapper;

    /**
     * 查询工装夹具清单
     *
     * @param toolId 工装夹具清单主键
     * @return 工装夹具清单
     */
    @Override
    public TmTool selectTmToolByToolId(Long toolId) {
        return tmToolMapper.selectTmToolByToolId(toolId);
    }

    /**
     * 查询工装夹具清单列表
     *
     * @param tmTool 工装夹具清单
     * @return 工装夹具清单
     */
    @Override
    public List<TmTool> selectTmToolList(TmTool tmTool) {
        return tmToolMapper.selectTmToolList(tmTool);
    }

    @Override
    public List<TmTool> selectDownMachineTmToolById(TmTool tmTool) {
        return tmToolMapper.selectDownMachineTmToolById(tmTool);
    }

    @Override
    public String checkToolCodeUnique(TmTool tmTool) {
        if (StringUtils.isNotNull(tmTool.getToolCode())) {
            TmTool tool = tmToolMapper.checkToolCodeUnique(tmTool);
            Long toolId = tmTool.getToolId() == null ? -1L : tmTool.getToolId();
            if (StringUtils.isNotNull(tool) && tool.getToolId().longValue() != toolId.longValue()) {
                return UserConstants.NOT_UNIQUE;
            }
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    @Override
    public int insertTmTool(TmTool tmTool) {
        tmTool.createAction();
        return tmToolMapper.insertTmTool(tmTool);
    }

    /**
     * 修改工装夹具清单
     *
     * @param tmTool 工装夹具清单
     * @return 结果
     */
    @Override
    public int updateTmTool(TmTool tmTool) {
        tmTool.updateAction();
        return tmToolMapper.updateTmTool(tmTool);
    }

    /**
     * 批量删除工装夹具清单
     *
     * @param toolIds 需要删除的工装夹具清单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolByToolIds(Long[] toolIds) {
        return tmToolMapper.deleteTmToolByToolIds(toolIds);
    }

    /**
     * 删除工装夹具清单信息
     *
     * @param toolId 工装夹具清单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolByToolId(Long toolId) {
        return tmToolMapper.deleteTmToolByToolId(toolId);
    }

    @Override
    public int deleteTmToolByToolCode(String toolCode) {
        QueryWrapper<TmTool> tmToolQueryWrapper = new QueryWrapper<>();
        tmToolQueryWrapper.eq("tool_code", toolCode);
        return tmToolMapper.deleteTmToolByQw(tmToolQueryWrapper);
    }

    @Transactional
    @Override
    public int insertObj(SAPDtoTmToolBody sapDtoTmToolBody) {
        List<SAPDtoTmToolBody.SAPDtoTmTool> tmTools = sapDtoTmToolBody.getTmTools();
        List<SAPDtoTmToolBody.SnBody> snBodies = sapDtoTmToolBody.getSnBodies();
        Map<String, List<SAPDtoTmToolBody.SnBody>> snBodyGroup = snBodies.stream().collect(Collectors.groupingBy(SAPDtoTmToolBody.SnBody::getSapItemCode));


        Set<String> itemCodeList = tmTools.stream().map(SAPDtoTmToolBody.SAPDtoTmTool::getSapItemCode).collect(Collectors.toSet());
        QueryWrapper<MdItem> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("sap_item_code", itemCodeList);
        Map<String, MdItem> itemMap = mdItemMapper.selectListByQw(queryWrapper).stream().filter(Objects::nonNull).collect(Collectors.toMap(MdItem::getSapItemCode, x -> x));


        for (SAPDtoTmToolBody.SAPDtoTmTool dtoTmTool : tmTools) {
            String code = dtoTmTool.getSapItemCode();
            List<SAPDtoTmToolBody.SnBody> snBodies1 = snBodyGroup.get(code);
            for (int i = 0; i < dtoTmTool.getQuantity().intValue(); i++) {
                for (SAPDtoTmToolBody.SnBody snBody : snBodies1) {
                    TmTool tmTool = new TmTool();
                    tmTool.setToolCode(snBody.getToolCode());
                    tmTool.setToolName(dtoTmTool.getItemName());
                    MdItem mdItem = itemMap.get(dtoTmTool.getSapItemCode());
                    if (mdItem != null) {
                        tmTool.setItemId(mdItem.getItemId());
                        tmTool.setSpecification(mdItem.getSpecification());
                    }
                    tmTool.setItemCode(dtoTmTool.getSapItemCode());
                    tmTool.setItemName(dtoTmTool.getItemName());
                    tmTool.setLocation(dtoTmTool.getLocal());

                    tmTool.setMaintenType(UserConstants.MAINTEN_TYPE_USAGE);
                    tmTool.setLifeTime(100000L);
                    tmTool.setQuantity(dtoTmTool.getQuantity());
                    tmTool.setQuantityAvail(dtoTmTool.getQuantity());
                    tmTool.setStatus(TmToolStatusEnum.STORE.getStatus());
                    tmTool.setOutboundNo(dtoTmTool.getOutboundOrderNo());
                    tmTool.setApiFlag(true);
                    this.insertTmTool(tmTool);
                }
            }
        }
        return 1;
    }
}
