package com.ximai.mes.tm.service.impl;

import com.ximai.mes.tm.domain.TmToolRequestUseItem;
import com.ximai.mes.tm.mapper.TmToolRequestUseItemMapper;
import com.ximai.mes.tm.service.ITmToolRequestUseItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 刀模版物料领用单Service业务层处理
 *
 * @author generator
 * @date 2024-02-02
 */
@Service
public class TmToolRequestUseItemServiceImpl implements ITmToolRequestUseItemService {
    @Autowired
    private TmToolRequestUseItemMapper tmToolRequestUseItemMapper;

    /**
     * 查询刀模版物料领用单
     *
     * @param toolRequestUseItemId 刀模版物料领用单主键
     * @return 刀模版物料领用单
     */
    @Override
    public TmToolRequestUseItem selectTmToolRequestUseItemByToolRequestUseItemId(Long toolRequestUseItemId) {
        return tmToolRequestUseItemMapper.selectTmToolRequestUseItemByToolRequestUseItemId(toolRequestUseItemId);
    }

    /**
     * 查询刀模版物料领用单列表
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 刀模版物料领用单
     */
    @Override
    public List<TmToolRequestUseItem> selectTmToolRequestUseItemList(TmToolRequestUseItem tmToolRequestUseItem) {
        return tmToolRequestUseItemMapper.selectTmToolRequestUseItemList(tmToolRequestUseItem);
    }

    /**
     * 新增刀模版物料领用单
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 结果
     */
    @Override
    public int insertTmToolRequestUseItem(TmToolRequestUseItem tmToolRequestUseItem) {
        tmToolRequestUseItem.createAction();
        return tmToolRequestUseItemMapper.insertTmToolRequestUseItem(tmToolRequestUseItem);
    }

    /**
     * 修改刀模版物料领用单
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 结果
     */
    @Override
    public int updateTmToolRequestUseItem(TmToolRequestUseItem tmToolRequestUseItem) {
        tmToolRequestUseItem.updateAction();
        return tmToolRequestUseItemMapper.updateTmToolRequestUseItem(tmToolRequestUseItem);
    }

    /**
     * 批量删除刀模版物料领用单
     *
     * @param toolRequestUseItemIds 需要删除的刀模版物料领用单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestUseItemByToolRequestUseItemIds(Long[] toolRequestUseItemIds) {
        return tmToolRequestUseItemMapper.deleteTmToolRequestUseItemByToolRequestUseItemIds(toolRequestUseItemIds);
    }

    /**
     * 删除刀模版物料领用单信息
     *
     * @param toolRequestUseItemId 刀模版物料领用单主键
     * @return 结果
     */
    @Override
    public int deleteTmToolRequestUseItemByToolRequestUseItemId(Long toolRequestUseItemId) {
        return tmToolRequestUseItemMapper.deleteTmToolRequestUseItemByToolRequestUseItemId(toolRequestUseItemId);
    }
}
