package com.ximai.mes.tm.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.constant.TmToolStatusEnum;
import com.ximai.mes.tm.domain.TmTool;
import com.ximai.mes.tm.domain.TmToolMaintenance;
import com.ximai.mes.tm.domain.TmToolMaintenanceProcess;
import com.ximai.mes.tm.mapper.TmToolMaintenanceMapper;
import com.ximai.mes.tm.mapper.TmToolMaintenanceProcessMapper;
import com.ximai.mes.tm.mapper.TmToolMapper;
import com.ximai.mes.tm.service.ITmToolMaintenanceService;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import static com.ximai.common.utils.SecurityUtils.getUsername;


/**
 * 要维护刀模版Service业务层处理
 *
 * @author generator
 * @date 2024-02-02
 */
@Service
public class TmToolMaintenanceServiceImpl implements ITmToolMaintenanceService {
    @Autowired
    private TmToolMaintenanceMapper tmToolMaintenanceMapper;

    @Autowired
    private TmToolMapper tmToolMapper;

    @Autowired
    private TmToolMaintenanceProcessMapper tmToolMaintenanceProcesMapper;

    @Autowired
    private AutoCodeUtil autoCodeUtil;


    /**
     * 查询要维护刀模版
     *
     * @param toolMaintenanceId 要维护刀模版主键
     * @return 要维护刀模版
     */
    @Override
    public TmToolMaintenance selectTmToolMaintenanceByToolMaintenanceId(Long toolMaintenanceId) {
        return tmToolMaintenanceMapper.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
    }

    /**
     * 查询要维护刀模版列表
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 要维护刀模版
     */
    @Override
    public List<TmToolMaintenance> selectTmToolMaintenanceList(TmToolMaintenance tmToolMaintenance) {

        return tmToolMaintenanceMapper.selectTmToolMaintenanceList(tmToolMaintenance);
    }

    /**
     * 新增要维护刀模版
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 结果
     */
    @Override
    public int insertTmToolMaintenance(TmToolMaintenance tmToolMaintenance) {
        tmToolMaintenance.setCreateTime(DateUtils.getNowDate());
        tmToolMaintenance.setMaintenanceStatus("NON");
        tmToolMaintenance.setToolMaintenanceCode(autoCodeUtil.genSerialCode(CODES, null));
        return tmToolMaintenanceMapper.insertTmToolMaintenance(tmToolMaintenance);
    }

    /**
     * 结束维护刀模版
     *
     * @param tmToolMaintenanc 要维护刀模版
     * @return 结果
     */
    @Override
    public int updateTmToolMaintenance(TmToolMaintenance tmToolMaintenanc) {
        TmToolMaintenanceProcess tmToolMaintenanceProcess = new TmToolMaintenanceProcess();
        Long toolMaintenanceId = tmToolMaintenanc.getToolMaintenanceId();
        TmToolMaintenance tmToolMaintenance = tmToolMaintenanceMapper.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
        tmToolMaintenance.setMaintenanceStatus("DONE");
        tmToolMaintenanceMapper.updateTmToolMaintenance(tmToolMaintenance);
        TmTool tool = tmToolMapper.selectTmToolByToolId(tmToolMaintenance.getToolId());
        tmToolMaintenanceProcess.setStartTime(tmToolMaintenanc.getStartTime());
        tmToolMaintenanceProcess.setToolMaintenanceId(toolMaintenanceId);
        tmToolMaintenanceProcess.setLifeTime(tmToolMaintenanc.getLifeTime());
        tmToolMaintenanceProcess.setProcessStatus(tmToolMaintenanc.getProcessStatus());
        tmToolMaintenanceProcess.setEndTime(tmToolMaintenanc.getEndTime());
        tmToolMaintenanceProcess.setProcessTime(tmToolMaintenanc.getProcessTime());
        tmToolMaintenanceProcess.setProcessId(tmToolMaintenanc.getProcessId());
        tool.setLifeTime(tmToolMaintenanceProcess.getLifeTime());
        if (tmToolMaintenanc.getProcessStatus().equals("UPTO")) {
            tool.setStatus(TmToolStatusEnum.STORE.getStatus());
            tool.setLocation(tmToolMaintenanc.getLocation());
            tmToolMapper.updateTmTool(tool);
        } else {
            tool.setStatus(TmToolStatusEnum.SCRAP.getStatus());
            tool.setLocation(tmToolMaintenanc.getLocation());
            tmToolMapper.updateTmTool(tool);
        }
        int i = tmToolMaintenanceProcesMapper.updateTmToolMaintenanceProcess(tmToolMaintenanceProcess);
        return i;
    }

    /**
     * 开始维护刀模版
     *
     * @param toolMaintenanceId
     * @return 结果
     */
    @Override
    public int deleteTmToolMaintenanceByToolMaintenanceIds(Long toolMaintenanceId) {
        TmToolMaintenanceProcess tmToolMaintenanceProcess1 = tmToolMaintenanceProcesMapper.selectTmToolMaintenanceId(toolMaintenanceId);
        if (tmToolMaintenanceProcess1 == null) {
            TmToolMaintenanceProcess tmToolMaintenanceProcess = new TmToolMaintenanceProcess();
            tmToolMaintenanceProcess.setToolMaintenanceId(toolMaintenanceId);
            Date nowDate = DateUtils.getNowDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String formattedDate = sdf.format(nowDate);
            tmToolMaintenanceProcess.setStartTime(formattedDate);
            tmToolMaintenanceProcess.setProcessPerson(getUsername());
            TmToolMaintenance tmToolMaintenance = tmToolMaintenanceMapper.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
            tmToolMaintenance.setMaintenanceStatus("UNDER");
            tmToolMaintenanceMapper.updateTmToolMaintenance(tmToolMaintenance);
            tmToolMaintenanceProcesMapper.insertTmToolMaintenanceProcess(tmToolMaintenanceProcess);
            TmToolMaintenance tmToolMaintenan = tmToolMaintenanceMapper.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
            Long toolId = tmToolMaintenan.getToolId();
            TmTool tool = tmToolMapper.selectTmToolByToolId(toolId);
            tool.setStatus(TmToolStatusEnum.REPARE.getStatus());
            tmToolMapper.updateTmTool(tool);
        }
        TmToolMaintenance tmToolMaintenace = tmToolMaintenanceMapper.selectTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
        Long toolMaintenanceId1 = tmToolMaintenace.getToolMaintenanceId();
        int intExact = Math.toIntExact(toolMaintenanceId1);

        return intExact;


    }

    @Override
    public int deleteTmToolMainToolMainIds(Long toolMaintenanceId) {
        if (tmToolMaintenanceProcesMapper.selectTmToolMaintenanceId(toolMaintenanceId) != null) {
            TmToolMaintenanceProcess tmToolMaintenanceProcess = tmToolMaintenanceProcesMapper.selectTmToolMaintenanceId(toolMaintenanceId);
            tmToolMaintenanceProcesMapper.deleteTmToolMaintenanceProcessByProcessId(tmToolMaintenanceProcess.getProcessId());
        }
        return tmToolMaintenanceMapper.deleteTmToolMaintenanceByToolMaintenanceId(toolMaintenanceId);
    }

    @Override
    public void insertTmToolMaintenances(TmToolMaintenance tmToolMaintenance) {
        List<TmTool> tmTools = tmToolMapper.selectTmToolList(new TmTool());

        List<TmToolMaintenance> tmToolMaintenances = tmToolMaintenanceMapper.selectTmToolMaintenanceList(tmToolMaintenance);
        for (TmTool tool : tmTools) {
            int i = 0;
            for (TmToolMaintenance tm : tmToolMaintenances) {
                if (tool.getToolCode() != null) {
                    if (tool.getToolCode().equals(tm.getToolCode())) {
                        i++;
                        if (tm.getMaintenanceStatus().equals("DONE")) {
                            int b = 0;
                            TmToolMaintenance tmToolMaintenance1 = new TmToolMaintenance();
                            tmToolMaintenance1.setToolCode(tm.getToolCode());
                            List<TmToolMaintenance> tmToolMaintenances1 = tmToolMaintenanceMapper.selectTmToolMaintenanceList(tmToolMaintenance1);
                            for (TmToolMaintenance tms : tmToolMaintenances1) {
                                if (tms.getMaintenanceStatus().equals("NON") || tms.getMaintenanceStatus().equals("UNDER")) {
                                    b++;
                                }
                            }
                            if (b == 0) {
                                i--;
                            }
                        }
                    }
                }
            }


            TmToolMaintenance tmToolMaintenance1 = new TmToolMaintenance();
            if (i == 0) {
                if (!tool.getStatus().equals("SCRAP")) {
                    if (tool.getLifeTime() != null && tool.getNextMaintenPeriod() != null) {
                        if (tool.getLifeTime() < tool.getNextMaintenPeriod()) {
                            tmToolMaintenance1.setToolMaintenanceCode(autoCodeUtil.genSerialCode(CODES, null));
                            tmToolMaintenance1.setItemCode(tool.getSapItemCode());
                            tmToolMaintenance1.setMaintenanceStatus("NON");
                            tmToolMaintenance1.setMaintenanceType("NORMAL");
                            tmToolMaintenance1.setToolId(tool.getToolId());
                            tmToolMaintenance1.setToolName(tool.getToolName());
                            tmToolMaintenance1.setToolCode(tool.getToolCode());
                            tmToolMaintenance1.setLocation(tool.getLocation());
                            tmToolMaintenance1.setCreateTime(DateUtils.getNowDate());
                            tmToolMaintenanceMapper.insertTmToolMaintenance(tmToolMaintenance1);
                            TmTool tmTool = tmToolMapper.selectTmToolByToolCode(tool.getToolCode());
                            tmTool.setStatus("REPARE");
                            tmToolMapper.updateTmTool(tmTool);
                        }
                    }
                }
            }
        }
    }


}
