package com.ximai.mes.tm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolRequestUseItem;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 刀模版物料领用单Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolRequestUseItemMapper extends BaseMapper<TmToolRequestUseItem> {
    /**
     * 查询刀模版物料领用单
     *
     * @param toolRequestUseItemId 刀模版物料领用单主键
     * @return 刀模版物料领用单
     */
    TmToolRequestUseItem selectTmToolRequestUseItemByToolRequestUseItemId(Long toolRequestUseItemId);


    @Select(value = "select tool_request_use_item_id, tool_request_use_id, " +
            "item_id, tool_id, location, create_by, create_time, " +
            "update_by, update_time from tm_tool_request_use_item where tool_request_use_item_id=#{toolRequestUseItemId}")
    TmToolRequestUseItem selectTmToolRequestUseItemToolRequestUseItemId(@Param("toolRequestUseItemId") Long toolRequestUseItemId);


    /**
     * 查询刀模版物料领用单列表
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 刀模版物料领用单集合
     */
    List<TmToolRequestUseItem> selectTmToolRequestUseItemList(TmToolRequestUseItem tmToolRequestUseItem);

    @Select("select ttu.* from tm_tool_request_use_item ttu inner join tm_tool tt on ttu.tool_id = tt.tool_id  ${ew.customSqlSegment}")
    List<TmToolRequestUseItem> selectListByQw(@Param("ew") QueryWrapper<TmToolRequestUseItem> query);

    @Select(value = "select t1.*,t2.tool_code from tm_tool_request_use_item t1 left join tm_tool  t2 on t1.tool_id = t2.tool_id ${ew.customSqlSegment}")
    List<TmToolRequestUseItem> selecListByQw(@Param("ew") QueryWrapper<TmToolRequestUseItem> queryWrapper);

    /**
     * 新增刀模版物料领用单
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 结果
     */
    int insertTmToolRequestUseItem(TmToolRequestUseItem tmToolRequestUseItem);

    /**
     * 修改刀模版物料领用单
     *
     * @param tmToolRequestUseItem 刀模版物料领用单
     * @return 结果
     */
    int updateTmToolRequestUseItem(TmToolRequestUseItem tmToolRequestUseItem);

    /**
     * 删除刀模版物料领用单
     *
     * @param toolRequestUseItemId 刀模版物料领用单主键
     * @return 结果
     */
    int deleteTmToolRequestUseItemByToolRequestUseItemId(Long toolRequestUseItemId);

    /**
     * 批量删除刀模版物料领用单
     *
     * @param toolRequestUseItemIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolRequestUseItemByToolRequestUseItemIds(Long[] toolRequestUseItemIds);

    /**
     * 通过申请单id批量删除刀模版物料领用单
     *
     * @param toolRequestUseIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteTmToolRequestUseItemByToolRequestUseIds(Long[] toolRequestUseIds);
}
