package com.ximai.mes.tm.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.tm.domain.TmToolRequestItem;

/**
 * 刀模版物料申请单Mapper接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface TmToolRequestItemMapper extends BaseMapper<TmToolRequestItem>
{
    /**
     * 查询刀模版物料申请单
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 刀模版物料申请单
     */
    public TmToolRequestItem selectTmToolRequestItemByToolRequestItemId(Long toolRequestItemId);

    /**
     * 查询刀模版物料申请单列表
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 刀模版物料申请单集合
     */
    public List<TmToolRequestItem> selectTmToolRequestItemList(TmToolRequestItem tmToolRequestItem);

    /**
     * 新增刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    public int insertTmToolRequestItem(TmToolRequestItem tmToolRequestItem);

    /**
     * 修改刀模版物料申请单
     *
     * @param tmToolRequestItem 刀模版物料申请单
     * @return 结果
     */
    public int updateTmToolRequestItem(TmToolRequestItem tmToolRequestItem);

    /**
     * 删除刀模版物料申请单
     *
     * @param toolRequestItemId 刀模版物料申请单主键
     * @return 结果
     */
    public int deleteTmToolRequestItemByToolRequestItemId(Long toolRequestItemId);

    /**
     * 批量删除刀模版物料申请单
     *
     * @param toolRequestItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteTmToolRequestItemByToolRequestItemIds(Long[] toolRequestItemIds);
}
