package com.ximai.mes.tm.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.tm.domain.TmToolRequestUseItem;
import com.ximai.mes.tm.service.ITmToolRequestUseItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 刀模版物料领用单Controller
 *
 * @author generator
 * @date 2024-02-02
 */
@RestController
@RequestMapping("/tm/tmToolRequestUseItem")
public class TmToolRequestUseItemController extends BaseController {
    @Autowired
    private ITmToolRequestUseItemService tmToolRequestUseItemService;

    /**
     * 查询刀模版物料领用单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUseItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolRequestUseItem tmToolRequestUseItem) {
        startPage();
        List<TmToolRequestUseItem> list = tmToolRequestUseItemService.selectTmToolRequestUseItemList(tmToolRequestUseItem);
        return getDataTable(list);
    }

    /**
     * 获取刀模版物料领用单详细信息
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUseItem:query')")
    @GetMapping(value = "/{toolRequestUseItemId}")
    public AjaxResult getInfo(@PathVariable("toolRequestUseItemId") Long toolRequestUseItemId) {
        return AjaxResult.success(tmToolRequestUseItemService.selectTmToolRequestUseItemByToolRequestUseItemId(toolRequestUseItemId));
    }

    /**
     * 新增刀模版物料领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUseItem:add')")
    @Log(title = "刀模版物料领用单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolRequestUseItem tmToolRequestUseItem) {
        return toAjax(tmToolRequestUseItemService.insertTmToolRequestUseItem(tmToolRequestUseItem));
    }

    /**
     * 修改刀模版物料领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUseItem:edit')")
    @Log(title = "刀模版物料领用单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolRequestUseItem tmToolRequestUseItem) {
        return toAjax(tmToolRequestUseItemService.updateTmToolRequestUseItem(tmToolRequestUseItem));
    }

    /**
     * 删除刀模版物料领用单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestUseItem:remove')")
    @Log(title = "刀模版物料领用单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolRequestUseItemIds}")
    public AjaxResult remove(@PathVariable Long[] toolRequestUseItemIds) {
        return toAjax(tmToolRequestUseItemService.deleteTmToolRequestUseItemByToolRequestUseItemIds(toolRequestUseItemIds));
    }
}
