package com.ximai.mes.tm.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.tm.domain.TmToolMachines;
import com.ximai.mes.tm.domain.TmToolMachinesRecord;
import com.ximai.mes.tm.service.ITmToolMachinesRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * 刀模版上下机记录Controller
 *
 * @author generator
 * @date 2024-02-06
 */
@RestController
@RequestMapping("/tm/tmToolMachinesRecord")
public class TmToolMachinesRecordController extends BaseController {
    @Autowired
    private ITmToolMachinesRecordService tmToolMachinesRecordService;

    /**
     * 查询刀模版上下机记录列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachinesRecord:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolMachinesRecord tmToolMachinesRecord) {
        startPage();
        List<TmToolMachinesRecord> list = tmToolMachinesRecordService.selectTmToolMachinesRecordList(tmToolMachinesRecord);
        return getDataTable(list);
    }


    /**
     * 获取刀模版上下机记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachinesRecord:query')")
    @GetMapping(value = "/{toolMachinesRecordId}")
    public AjaxResult getInfo(@PathVariable("toolMachinesRecordId") Long toolMachinesRecordId) {
        return AjaxResult.success(tmToolMachinesRecordService.selectTmToolMachinesRecordByToolMachinesRecordId(toolMachinesRecordId));
    }

    /**
     * 新增刀模版上下机记录
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachinesRecord:add')")
    @Log(title = "刀模版上下机记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolMachinesRecord tmToolMachinesRecord) {
        return toAjax(tmToolMachinesRecordService.insertTmToolMachinesRecord(tmToolMachinesRecord));
    }

    /**
     * 修改刀模版上下机记录(传入主键id及操作类型1上机，2下机)
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachinesRecord:edit')")
    @Log(title = "刀模版上下机记录(传入主键id及操作类型1上机，2下机)", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolMachinesRecord tmToolMachinesRecord) {
        List<Long> toolMachinesRecordIdList = tmToolMachinesRecord.getToolMachinesRecordIdList();
        Integer type = tmToolMachinesRecord.getType();
        int i = 0;
        if (CollectionUtil.isNotEmpty(toolMachinesRecordIdList)) {
            for (Long toolMachinesRecordId : toolMachinesRecordIdList) {
                TmToolMachinesRecord tmToolMachinesRecordPo = tmToolMachinesRecordService.selectByToolMachinesRecordId(toolMachinesRecordId);

                if (null != type) {
                    //上机修改状态，上机时间改为最新；下机修改状态，下机时间改为最新
                    if (1 == type) {
                        tmToolMachinesRecordPo.setType(1);
                        tmToolMachinesRecordPo.setUpDate(new Date());
                    } else if (2 == type) {
                        tmToolMachinesRecordPo.setType(2);
                        tmToolMachinesRecordPo.setDownDate(new Date());
                    }
                }

                tmToolMachinesRecordService.updateTmToolMachinesRecord(tmToolMachinesRecordPo);
                i++;
            }
        }

        return toAjax(i);
    }

    /**
     * 删除刀模版上下机记录
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolMachinesRecord:remove')")
    @Log(title = "刀模版上下机记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{toolMachinesRecordIds}")
    public AjaxResult remove(@PathVariable Long[] toolMachinesRecordIds) {
        return toAjax(tmToolMachinesRecordService.deleteTmToolMachinesRecordByToolMachinesRecordIds(toolMachinesRecordIds));
    }

    /**
     * 通过工序和编排单号获取上下机列表
     */
    @PutMapping(value = "/getRecordsByProcessIdAndArrangeCode")
    public AjaxResult getRecordsByProcessIdAndArrangeCode(@RequestBody TmToolMachines tmToolMachines) {
        return AjaxResult.success(tmToolMachinesRecordService.getRecordsByProcessIdAndArrangeCode(tmToolMachines));
    }
}
