package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.md.service.IMdWorkunitService;
import com.ximai.mes.md.vo.MdWorkunitVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * title: 工作单元接口
 * author:ZHT
 * date:2024/3/18
 * description:
 */
@RestController
@RequestMapping(value = "/api/v1/workunit")
public class WorkunitRestController {

    @Autowired
    private IMdWorkunitService mdWorkunitService;

    //consumes = "text/plain;charset=UTF-8"
    @ApiOperation(value = "工作单元创建")
    @BasicAuth
    @RequestMapping(value = "/workunitCreate", method = RequestMethod.POST,consumes = "text/plain;charset=UTF-8")
    public AjaxResult WorkunitCreate(@RequestBody String mdWorkunitJson ) {


        try{
            MdWorkunitVo mdWorkunitVo = JSON.parseObject(mdWorkunitJson).toJavaObject(MdWorkunitVo.class);
            int i = mdWorkunitService.workunitCreate(mdWorkunitVo);
            if(i == 2)
                return  AjaxResult.success("修改成功");
            if(i == 3)
                return  AjaxResult.success("删除成功");
            if(i == 4)
                return AjaxResult.error("没有匹配到数据所绑定的工作中心");
        }catch (Exception e){
            return AjaxResult.error(e.getMessage());
        }

        return AjaxResult.success("新增成功");
    }

}
