package com.ximai.mes.restful;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.domain.SapAjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.constant.WorkorderConst;
import com.ximai.mes.constant.WorkorderSAPStatusEnum;
import com.ximai.mes.constant.WorkorderStatusEnum;
import com.ximai.mes.pro.domain.ep.EPDtoProWorkOrder;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderChangeRecord;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.sap.SAPDtoProWorkOrder;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderChangeRecordService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.*;

import static com.ximai.common.constant.Constants.*;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/21
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/v1/workOrder")
public class WorkorderRestController extends BaseController {

    @Autowired
    private IProWorkorderService proWorkorderService;
    @Resource
    private ProWorkorderMapper proWorkorderMapper;
    @Autowired
    private IProWorkOrderChangeRecordService proWorkOrderChangeRecordService;


    @ApiOperation(value = "查询工序任务状态")
    @BasicAuth
    @RequestMapping(value = "/getWorkorderProcessInfo", method = RequestMethod.POST)
    public AjaxResult getWorkorderProcessInfo(@RequestBody Map mapArg) {
        String workorderCode = mapArg.get("code").toString();
        return AjaxResult.success(proWorkorderService.getWorkorderProcessInfo(workorderCode));
    }


    @ApiOperation(value = "查询生产销售订单关系")
    @BasicAuth
    @RequestMapping(value = "/saleList", method = RequestMethod.GET)
    public TableDataInfo saleList(ProWorkorder proWorkorder) {
        List<ProWorkorder> proWorkorders = proWorkorderService.selectSaleAndWorkorderList(proWorkorder);
        List<Map<String, Object>> objects = new ArrayList<>();
        for (ProWorkorder workorder : proWorkorders) {
            Map<String, Object> map = new HashMap<>();
            map.put("workorderCode", workorder.getWorkorderCode());
            map.put("arrangeCode", workorder.getArrangeCode());
            map.put("salesVoucher", workorder.getSalesVoucher());
            map.put("salesVoucherItem", workorder.getSalesVoucherItem());
            objects.add(map);
        }

        return getDataTable(objects);
    }



}
