package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProWorkstationMaterial;
import com.ximai.mes.pro.domain.vo.ProWorkstationMaterialVo;
import com.ximai.mes.pro.service.IProWorkstationMaterialService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 工作中心发料的接口查询
 */

@RestController
@RequestMapping(value = "/apiPda/workstationMaterial")
public class PdaWorkstationMaterialRestController extends BaseController {

    @Autowired
    private IProWorkstationMaterialService proWorkstationMaterialService;


      @ApiOperation(value = "Pda查看工作中心发料")
      @RequestMapping(value = "/pdaWortstation", method = RequestMethod.GET)
      public TableDataInfo workstationSearch(ProWorkstationMaterialVo proWorkstationMaterialVo){

          String applyNo = proWorkstationMaterialVo.getApplyNo();
          if(Objects.equals(applyNo, "") || StringUtils.isEmpty(applyNo)){
              QueryWrapper<ProWorkstationMaterial> query = new QueryWrapper<>();
              List<ProWorkstationMaterialVo> list = proWorkstationMaterialService.selectProWorkstationMaterialLists(query);
              List<ProWorkstationMaterialVo> lists = list.stream().filter(s ->!s.getWindCase().equals("Y")).collect(Collectors.toList());
              return getDataTable(lists);
          }else{
              QueryWrapper<ProWorkstationMaterial> query = new QueryWrapper<>();
              query.eq(applyNo != null, "p.apply_no", applyNo);
              List<ProWorkstationMaterialVo> list = proWorkstationMaterialService.selectProWorkstationMaterialLists(query);
              List<ProWorkstationMaterialVo> lists = list.stream().filter(s ->!s.getWindCase().equals("Y")).collect(Collectors.toList());
              return getDataTable(lists);
          }
      }


      @ApiOperation(value = "pda传mes回传工作中心领料数据")
      @RequestMapping(value = "/pdaworkstationUpadteNum")
      public AjaxResult workstationUpadteNum(@RequestBody String WorkstationMateria ){
          try {
              List<ProWorkstationMaterial> proWorkstationMaterials = JSON.parseArray(WorkstationMateria, ProWorkstationMaterial.class);
              proWorkstationMaterialService.updateWorkstationUpadteNum(proWorkstationMaterials);
          }catch (Exception e){
              return AjaxResult.error(e.getMessage());
          }

          return AjaxResult.success("操作成功");
      }






}
