package com.ximai.mes.report.controller;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.report.request.DailyProductionReportRequest;
import com.ximai.mes.report.request.FeedbackRequest;
import com.ximai.mes.report.response.FeedbackResponse;
import com.ximai.mes.report.service.DailyProductionReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Api("日产能对比统计")
@RestController
@RequestMapping("/dailyProductionReport")
public class DailyProductionReportController  extends BaseController {
    @Autowired
    DailyProductionReportService dailyProductionReportService;

    @ApiOperation("日产能对比统计:获取日期表头")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:获取日期表头", businessType = BusinessType.QUERY)
    @GetMapping("/getDatas")
    public AjaxResult<List> getDatas(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getDatas(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }


    @ApiOperation("日产能对比统计:统计方式工序")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:统计方式工序", businessType = BusinessType.QUERY)
    @GetMapping("/getListByProcess")
    public AjaxResult<List> getListByProcess(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByProcess(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }

    /**
     * 明细界面导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "日产能对比统计:统计方式工序导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByProcess/export")
    @ApiOperation("日产能对比统计:统计方式工序导出")
    public void export(HttpServletResponse response, DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByProcess(dailyProductionReportRequest);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = dailyProductionReportService.getAscDateList(startDate, endDate);
        dailyProductionReportService.export(response,data,"日产能对比统计-统计方式工序导出","工序名称","工序编码","工序",  dateList);
    }

    @ApiOperation("日产能对比统计:统计方式车间")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:统计方式车间", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkshop")
    public AjaxResult<List> getListByWorkshop(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkshop(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }

    /**
     * 日产能对比统计:统计方式车间导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "日产能对比统计:统计方式车间导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkshop/export")
    @ApiOperation("日产能对比统计:统计方式车间导出")
    public void getListByWorkshopExport(HttpServletResponse response, DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkshop(dailyProductionReportRequest);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = dailyProductionReportService.getAscDateList(startDate, endDate);
        dailyProductionReportService.export(response,data,"日产能对比统计-统计方式车间导出","车间名称","车间编码","车间",  dateList);
    }


    @ApiOperation("日产能对比统计:统计方式工作中心")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:统计方式工作中心", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkstation")
    public AjaxResult<List> getListByWorkstation(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkstation(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }

    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "日产能对比统计:统计方式工作中心导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkstation/export")
    @ApiOperation("日产能对比统计:统计方式工作中心导出")

    public void getListByWorkstationExport(HttpServletResponse response, DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkstation(dailyProductionReportRequest);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = dailyProductionReportService.getAscDateList(startDate, endDate);
        dailyProductionReportService.export(response,data,"日产能对比统计-统计方式工作中心导出","工作中心名称","工作中心编码","工作中心",  dateList);
    }




    @ApiOperation("日产能对比统计:统计方式工作单元")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:统计方式工作单元", businessType = BusinessType.QUERY)
    @GetMapping("/getListByWorkunit")
    public AjaxResult<List> getListByWorkunit(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkunit(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }



    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "日产能对比统计:统计方式工作单元导出", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByWorkunit/export")
    @ApiOperation("日产能对比统计:统计方式工作单元导出")
    public void getListByWorkunitExport(HttpServletResponse response, DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByWorkunit(dailyProductionReportRequest);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = dailyProductionReportService.getAscDateList(startDate, endDate);
        dailyProductionReportService.export(response,data,"日产能对比统计-统计方式工作单元导出","工作单元名称","工作单元编码","工作单元",  dateList);
    }



    @ApiOperation("日产能对比统计:统计方式报工人员")
    @PreAuthorize("@ss.hasPermi('mes:pro:dailyProductionReport:get')")
    @Log(title = "日产能对比统计:统计方式报工人员", businessType = BusinessType.QUERY)
    @GetMapping("/getListByUser")
    public AjaxResult<List> getListByUser(DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByUser(dailyProductionReportRequest);
        return AjaxResult.success(data);
    }


    /**
     * 日产能对比统计:统计方式工作中心导出
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "日产能对比统计:统计方式报工人员", businessType = BusinessType.EXPORT)
    @PostMapping("/getListByUser/export")
    @ApiOperation("日产能对比统计:统计方式报工人员")
    public void getListByUserExport(HttpServletResponse response, DailyProductionReportRequest dailyProductionReportRequest) {
        List data = dailyProductionReportService.getListByUser(dailyProductionReportRequest);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = simpleDateFormat.format(dailyProductionReportRequest.getStartDate());
        String endDate = simpleDateFormat.format(dailyProductionReportRequest.getEndDate());
        List<String> dateList = dailyProductionReportService.getAscDateList(startDate, endDate);
        dailyProductionReportService.export(response,data,"日产能对比统计-统计方式报工人员导出","报工人员名称","报工人员编码","报工人员",  dateList);
    }
}
