package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.qc.domain.QcMobParam;
import com.ximai.mes.qc.domain.QcTemplate;

import java.util.List;

/**
 * 检测模板Mapper接口
 *
 * @date 2022-05-17
 */
public interface QcTemplateMapper extends BaseMapper<QcTemplate> {
    /**
     * 查询检测模板
     *
     * @param templateId 检测模板主键
     * @return 检测模板
     */
    QcTemplate selectQcTemplateByTemplateId(Long templateId);

    /**
     * 查询检测模板列表
     *
     * @param qcTemplate 检测模板
     * @return 检测模板集合
     */
    List<QcTemplate> selectQcTemplateList(QcTemplate qcTemplate);


    /**
     * 根据检测类型和产品查找对应的检测模板
     *
     * @param qcTemplate
     */
    QcTemplate selectQcTemplateByItemIdAndQcType(QcTemplate qcTemplate);


    /**
     * 根据物料/产品和检验类型查询对应的检测模板
     *
     * @param param
     * @return
     */
    QcTemplate findTemplateByProductIdAndQcType(QcMobParam param);


    QcTemplate checkTemplateCodeUnique(QcTemplate qcTemplate);

    /**
     * 新增检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    int insertQcTemplate(QcTemplate qcTemplate);

    /**
     * 修改检测模板
     *
     * @param qcTemplate 检测模板
     * @return 结果
     */
    int updateQcTemplate(QcTemplate qcTemplate);

    /**
     * 删除检测模板
     *
     * @param templateId 检测模板主键
     * @return 结果
     */
    int deleteQcTemplateByTemplateId(Long templateId);

    /**
     * 批量删除检测模板
     *
     * @param templateIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcTemplateByTemplateIds(Long[] templateIds);
}
