package com.ximai.mes.qc.mapper;

import java.util.List;
import com.ximai.mes.qc.domain.QcIpqcLine;

/**
 * 过程检验单行Mapper接口
 *
 * @date 2022-08-30
 */
public interface QcIpqcLineMapper
{
    /**
     * 查询过程检验单行
     *
     * @param lineId 过程检验单行主键
     * @return 过程检验单行
     */
     QcIpqcLine selectQcIpqcLineByLineId(Long lineId);

    /**
     * 查询过程检验单行列表
     *
     * @param qcIpqcLine 过程检验单行
     * @return 过程检验单行集合
     */
     List<QcIpqcLine> selectQcIpqcLineList(QcIpqcLine qcIpqcLine);

    /**
     * 新增过程检验单行
     *
     * @param qcIpqcLine 过程检验单行
     * @return 结果
     */
     int insertQcIpqcLine(QcIpqcLine qcIpqcLine);

    /**
     * 修改过程检验单行
     *
     * @param qcIpqcLine 过程检验单行
     * @return 结果
     */
     int updateQcIpqcLine(QcIpqcLine qcIpqcLine);

    /**
     * 根据缺陷记录更新过程检验单行上的缺陷数量
     * @param qcIpqcLine
     * @return
     */
     int updateCrMajMinQuantity(QcIpqcLine qcIpqcLine);

    /**
     * 删除过程检验单行
     *
     * @param lineId 过程检验单行主键
     * @return 结果
     */
     int deleteQcIpqcLineByLineId(Long lineId);

    /**
     * 批量删除过程检验单行
     *
     * @param lineIds 需要删除的数据主键集合
     * @return 结果
     */
     int deleteQcIpqcLineByLineIds(Long[] lineIds);

    /***
     * 根据检验单头ID删除所有行信息
     * @param ipqcId
     * @return
     */
     int deleteByIpqcId(Long ipqcId);
}
