package com.ximai.mes.qc.domain;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 过程检验单行对象 qc_ipqc_line
 *
 * @date 2022-08-30
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class QcIpqcLine extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 记录ID
     */
    private Long lineId;
    private Long qcTemplateIndexId;
    private Integer inputType;

    @TableField(exist = false)
    private String selectValues;

    /**
     * 检验单ID
     */
    @Excel(name = "检验单ID")
    private Long ipqcId;

    /**
     * 检测项ID
     */
    @Excel(name = "检测项ID")
    private Long indexId;

    /**
     * 检测项编码
     */
    @Excel(name = "检测项编码")
    private String indexCode;

    /**
     * 检测项名称
     */
    @Excel(name = "检测项名称")
    private String indexName;

    /**
     * 检测项类型
     */
    @Excel(name = "检测项类型")
    private String indexType;

    /**
     * 检测工具
     */
    @Excel(name = "检测工具")
    private String qcTool;

    /**
     * 检测要求
     */
    @Excel(name = "检测要求")
    private String checkMethod;

    /**
     * 标准值
     */
    @Excel(name = "标准值")
    private BigDecimal standerVal;

    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 误差上限
     */
    @Excel(name = "误差上限")
    private BigDecimal thresholdMax;

    /**
     * 误差下限
     */
    @Excel(name = "误差下限")
    private BigDecimal thresholdMin;

    /**
     * 致命缺陷数量
     */
    @Excel(name = "致命缺陷数量")
    private BigDecimal crQuantity;

    /**
     * 严重缺陷数量
     */
    @Excel(name = "严重缺陷数量")
    private BigDecimal majQuantity;

    /**
     * 轻微缺陷数量
     */
    @Excel(name = "轻微缺陷数量")
    private BigDecimal minQuantity;

    private String qualityCheckResults;
    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

}
