package com.ximai.mes.qc.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.util.List;

/**
 * 检测项对象 qc_index
 *
 * @date 2022-05-17
 */
@Data
public class QcIndex extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 检测项ID
     */
    @TableId
    private Long indexId;

    @TableField(exist = false)
    private List<String> indexIds;

    /**
     * 检测项编码
     */
    @Excel(name = "检测项编码")
    private String indexCode;

    /**
     * 检测项名称
     */
    @Excel(name = "检测项名称")
    private String indexName;

    /**
     * 检测项类型
     */
    @Excel(name = "检测项类型")
    private String indexType;

    /**
     * 输入类型
     */
    private Integer inputType;

    /**
     * 检测工具
     */
    @Excel(name = "检测工具")
    private String qcTool;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;
}
