package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionRequest.ProProductionRequestBomMapper;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestBom;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestBomService;

/**
 * 量产申请BOMService业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@Service
public class ProProductionRequestBomServiceImpl implements IProProductionRequestBomService
{
    @Autowired
    private ProProductionRequestBomMapper proProductionRequestBomMapper;

    /**
     * 查询量产申请BOM
     *
     * @param bomItemId 量产申请BOM主键
     * @return 量产申请BOM
     */
    @Override
    public ProProductionRequestBom selectProProductionRequestBomByBomItemId(Long bomItemId)
    {
        return proProductionRequestBomMapper.selectProProductionRequestBomByBomItemId(bomItemId);
    }

    /**
     * 查询量产申请BOM列表
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 量产申请BOM
     */
    @Override
    public List<ProProductionRequestBom> selectProProductionRequestBomList(ProProductionRequestBom proProductionRequestBom)
    {
        return proProductionRequestBomMapper.selectProProductionRequestBomList(proProductionRequestBom);
    }

    /**
     * 新增量产申请BOM
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 结果
     */
    @Override
    public int insertProProductionRequestBom(ProProductionRequestBom proProductionRequestBom)
    {
        return proProductionRequestBomMapper.insertProProductionRequestBom(proProductionRequestBom);
    }

    /**
     * 修改量产申请BOM
     *
     * @param proProductionRequestBom 量产申请BOM
     * @return 结果
     */
    @Override
    public int updateProProductionRequestBom(ProProductionRequestBom proProductionRequestBom)
    {
        return proProductionRequestBomMapper.updateProProductionRequestBom(proProductionRequestBom);
    }

    /**
     * 批量删除量产申请BOM
     *
     * @param bomItemIds 需要删除的量产申请BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestBomByBomItemIds(Long[] bomItemIds)
    {
        return proProductionRequestBomMapper.deleteProProductionRequestBomByBomItemIds(bomItemIds);
    }

    /**
     * 删除量产申请BOM信息
     *
     * @param bomItemId 量产申请BOM主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestBomByBomItemId(Long bomItemId)
    {
        return proProductionRequestBomMapper.deleteProProductionRequestBomByBomItemId(bomItemId);
    }
}
