package com.ximai.mes.pro.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.ProBom;
import com.ximai.mes.pro.mapper.ProBomMapper;
import com.ximai.mes.pro.service.IProBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * BOMService业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class ProBomServiceImpl implements IProBomService
{
    @Autowired
    private ProBomMapper proBomMapper;

    /**
     * 查询BOM
     *
     * @param bomId BOM主键
     * @return BOM
     */
    @Override
    public ProBom selectProBomByBomId(Long bomId)
    {
        return proBomMapper.selectProBomByBomId(bomId);
    }

    /**
     * 查询BOM列表
     *
     * @param proBom BOM
     * @return BOM
     */
    @Override
    public List<ProBom> selectProBomList(ProBom proBom)
    {
        return proBomMapper.selectProBomList(proBom);
    }

    /**
     * 新增BOM
     *
     * @param proBom BOM
     * @return 结果
     */
    @Override
    public int insertProBom(ProBom proBom)
    {
        proBom.setCreateTime(DateUtils.getNowDate());
        return proBomMapper.insertProBom(proBom);
    }

    /**
     * 修改BOM
     *
     * @param proBom BOM
     * @return 结果
     */
    @Override
    public int updateProBom(ProBom proBom)
    {
        proBom.setUpdateTime(DateUtils.getNowDate());
        return proBomMapper.updateProBom(proBom);
    }

    /**
     * 批量删除BOM
     *
     * @param bomIds 需要删除的BOM主键
     * @return 结果
     */
    @Override
    public int deleteProBomByBomIds(Long[] bomIds)
    {
        return proBomMapper.deleteProBomByBomIds(bomIds);
    }

    /**
     * 删除BOM信息
     *
     * @param bomId BOM主键
     * @return 结果
     */
    @Override
    public int deleteProBomByBomId(Long bomId)
    {
        return proBomMapper.deleteProBomByBomId(bomId);
    }
}
