package com.ximai.mes.pro.schedule;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class OptionalTimeSpan {

    public OptionalTimeSpan(Type type){
        this.type=type;
    }

    private Type type;
    private List<Supplier<Duration>> optionalList = new ArrayList<Supplier<Duration>>();

    public void addOptional(Supplier<Duration> getFunc)
    {
        optionalList.add(getFunc);
    }

    public void addOptional(Duration duration)
    {
        optionalList.add(() -> duration);
    }

    public boolean Waiting(){
        return Get().get()==null;
    }

    private Supplier<Duration> Get(){
        return ()-> get();
    };

    public Duration get()
    {
        List<Duration> tempList = optionalList.stream().map(s->s.get()).collect(Collectors.toList());
        if (tempList.isEmpty())
        {
            return null;
        }
        if(type == Type.Max)
        {
            return tempList.stream().max(Comparator.comparing(Duration::getSeconds)).get();
        }
        return tempList.stream().min(Comparator.comparing(Duration::getSeconds)).get();
    }

    public enum Type
    {
        Max,
        Min
    }
}
