package com.ximai.mes.pro.mapper.task;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.task.ProTaskWorkunitConvertRecord;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitConvertRecordDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

/**
 * 任务派工转换记录Mapper接口
 *
 * @author generator
 * @date 2024-09-20
 */
public interface ProTaskWorkunitConvertRecordMapper extends BaseMapper<ProTaskWorkunitConvertRecord>
{
    /**
     * 查询任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 任务派工转换记录
     */
    public ProTaskWorkunitConvertRecordDto selectProTaskWorkunitConvertRecordById(Long id);

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 任务派工转换记录集合
     */
    public List<ProTaskWorkunitConvertRecordDto> selectProTaskWorkunitConvertRecordList(ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord);

    /**
     * 查询任务派工转换记录列表
     *
     * @param proTaskWorkunitConvertRecordQuery 任务派工转换记录
     * @return 任务派工转换记录集合
     */
    @Select("select m.* from pro_task_workunit_convert_record m ${ew.customSqlSegment}")
    public List<ProTaskWorkunitConvertRecordDto> selectDtoListByQw(@Param("ew") QueryWrapper<ProTaskWorkunitConvertRecord> proTaskWorkunitConvertRecordQuery);

    /**
     * 新增任务派工转换记录
     *
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 结果
     */
    public int insertProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord);

    /**
     * 修改任务派工转换记录
     *
     * @param proTaskWorkunitConvertRecord 任务派工转换记录
     * @return 结果
     */
    public int updateProTaskWorkunitConvertRecord(ProTaskWorkunitConvertRecord proTaskWorkunitConvertRecord);

    /**
     * 删除任务派工转换记录
     *
     * @param id 任务派工转换记录主键
     * @return 结果
     */
    public int deleteProTaskWorkunitConvertRecordById(Long id);

    /**
     * 批量删除任务派工转换记录
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProTaskWorkunitConvertRecordByIds(Long[] ids);
}
