package com.ximai.mes.pro.mapper.task;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.task.ProPackagePrintRecord;
import com.ximai.mes.pro.domain.vo.ProPackagePrintRecordQuery;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 报工包装标签打印记录表Mapper接口
 *
 * @author generator
 * @date 2024-03-19
 */
public interface ProPackagePrintRecordMapper extends BaseMapper<ProPackagePrintRecord>
{
    /**
     * 查询报工包装标签打印记录表
     *
     * @param recordId 报工包装标签打印记录表主键
     * @return 报工包装标签打印记录表
     */
    public ProPackagePrintRecord selectProPackagePrintRecordByRecordId(Long recordId);

    /**
     * 查询报工包装标签打印记录表列表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 报工包装标签打印记录表集合
     */
    public List<ProPackagePrintRecord> selectProPackagePrintRecordList(ProPackagePrintRecordQuery proFdPackagePrintRecord);
    /**
     * 查询报工包装标签打印记录表列表
     *
     * @param query 报工包装标签打印记录表
     * @return 报工包装标签打印记录表集合
     */
    @Select(value = "select * from pro_package_print_record\n" +
            "${ew.customSqlSegment} " )
    public List<ProPackagePrintRecord> selectProPackagePrintRecordListByQw(@Param("ew") QueryWrapper<ProPackagePrintRecord> query);

    /**
     * 新增报工包装标签打印记录表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 结果
     */
    public int insertProPackagePrintRecord(ProPackagePrintRecord proFdPackagePrintRecord);

    /**
     * 修改报工包装标签打印记录表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 结果
     */
    public int updateProPackagePrintRecord(ProPackagePrintRecord proFdPackagePrintRecord);

    /**
     * 删除报工包装标签打印记录表
     *
     * @param recordId 报工包装标签打印记录表主键
     * @return 结果
     */
    public int deleteProPackagePrintRecordByRecordId(Long recordId);

    /**
     * 批量删除报工包装标签打印记录表
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPackagePrintRecordByRecordIds(Long[] recordIds);

    @Select(value = "select count(*) from pro_package_print_record\n" +
            "${ew.customSqlSegment} " )
    public int count(@Param("ew") QueryWrapper<ProPackagePrintRecord> query);

    /**
     * 打印次数更新
     * @param query
     * @return
     */
    @Select(value = "update pro_package_print_record set print_time=ifnull(print_time,0)+1\n" +
            "${ew.customSqlSegment} " )
    public void printTimeAccumulation(@Param("ew") QueryWrapper<ProPackagePrintRecord> query);
}
