package com.ximai.mes.pro.mapper.prototypeRequest;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestBom;
import org.apache.ibatis.annotations.Param;

/**
 * 打样申请BOMMapper接口
 *
 * @author zht
 * @date 2024-01-18
 */
public interface ProPrototypeRequestBomMapper
{
    /**
     *  根据打样单id查询所有BOM
     */
    public List<ProPrototypeRequestBom> selectProPrototypeRequestBomByPrototypeRequestId(@Param("prototypeRequestId") Long prototypeRequestId);
    /**
     * 查询打样申请BOM
     *
     * @param bomItemId 打样申请BOM主键
     * @return 打样申请BOM
     */
    public ProPrototypeRequestBom selectProPrototypeRequestBomByBomItemId(Long bomItemId);

    /**
     * 查询打样申请BOM列表
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 打样申请BOM集合
     */
    public List<ProPrototypeRequestBom> selectProPrototypeRequestBomList(ProPrototypeRequestBom proPrototypeRequestBom);

    /**
     * 新增打样申请BOM
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 结果
     */
    public int insertProPrototypeRequestBom(ProPrototypeRequestBom proPrototypeRequestBom);

    /**
     * 修改打样申请BOM
     *
     * @param proPrototypeRequestBom 打样申请BOM
     * @return 结果
     */
    public int updateProPrototypeRequestBom(ProPrototypeRequestBom proPrototypeRequestBom);

    /**
     * 删除打样申请BOM
     *
     * @param bomItemId 打样申请BOM主键
     * @return 结果
     */
    public int deleteProPrototypeRequestBomByBomItemId(Long bomItemId);

    /**
     * 批量删除打样申请BOM
     *
     * @param bomItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeRequestBomByBomItemIds(Long[] bomItemIds);
}
