package com.ximai.mes.pro.mapper.productionSolution;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产方案规格书Mapper接口
 *
 * @author zht
 * @date 2024-03-23
 */
public interface ProProductionSolutionSpecificationSheetMapper extends BaseMapper<ProProductionSolutionSpecificationSheet> {
    /**
     * 查询生产方案规格书
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 生产方案规格书
     */
    ProProductionSolutionSpecificationSheet selectProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId);

    /**
     * 查询生产方案规格书列表
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 生产方案规格书集合
     */
    List<ProProductionSolutionSpecificationSheet> selectProProductionSolutionSpecificationSheetList(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 新增生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    int insertProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 修改生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    int updateProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 删除生产方案规格书
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 结果
     */
    int deleteProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId);

    /**
     * 批量删除生产方案规格书
     *
     * @param specificationSheetIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProProductionSolutionSpecificationSheetBySpecificationSheetIds(Long[] specificationSheetIds);

    /**
     * 通过生产版本查找规格说明书
     *
     * @param productionSolutionId
     * @return
     */
    ProProductionSolutionSpecificationSheet selectSpecificationSheetByProductionSolutionId(Long productionSolutionId);


    /**
     * 通过生产版本查找规格说明书
     *
     * @return
     */
    @Select(value = "SELECT\n" +
            "\t* \n" +
            "FROM\n" +
            "\tpro_production_solution_specification_sheet \n" +
            "WHERE\n" +
            "\tproduction_solution_id = (\n" +
            "SELECT\n" +
            "\tv1.production_solution_id \n" +
            "FROM\n" +
            "\tpro_production_solution v1\n" +
            "\tINNER JOIN ( SELECT group_key, group_counter, sap_item_code, workorder_id FROM pro_workorder WHERE workorder_id = #{workorderId} ) v2 ON v1.group_key = v2.group_key \n" +
            "\tAND v1.group_counter = v2.group_counter AND v1.sap_item_code = v2.sap_item_code \n" +
            "\t)")
    ProProductionSolutionSpecificationSheet selectByWorkOrderId(@Param("workorderId") Long workorderId);
}
