package com.ximai.mes.pro.mapper;

import com.ximai.mes.pro.domain.ProWorkorderBomm;

import java.util.List;

/**
 * 生产工单BOM组成Mapper接口
 *
 * @date 2022-05-09
 */
public interface ProWorkorderBomMapper {
    /**
     * 查询生产工单BOM组成
     *
     * @param lineId 生产工单BOM组成主键
     * @return 生产工单BOM组成
     */
    ProWorkorderBomm selectProWorkorderBomByLineId(Long lineId);

    /**
     * 查询生产工单BOM组成列表
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 生产工单BOM组成集合
     */
    List<ProWorkorderBomm> selectProWorkorderBomList(ProWorkorderBomm proWorkorderBomm);

    /**
     * 新增生产工单BOM组成
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 结果
     */
    int insertProWorkorderBom(ProWorkorderBomm proWorkorderBomm);

    /**
     * 修改生产工单BOM组成
     *
     * @param proWorkorderBomm 生产工单BOM组成
     * @return 结果
     */
    int updateProWorkorderBom(ProWorkorderBomm proWorkorderBomm);

    /**
     * 删除生产工单BOM组成
     *
     * @param lineId 生产工单BOM组成主键
     * @return 结果
     */
    int deleteProWorkorderBomByLineId(Long lineId);

    /**
     * 批量删除生产工单BOM组成
     *
     * @param lineIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProWorkorderBomByLineIds(Long[] lineIds);

    int deleteProWorkorderBomByWorkorderId(Long workorderId);
}
