package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProProcess;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产工序Mapper接口
 *
 * @date 2022-05-11
 */
public interface ProProcessMapper {
    /**
     * 查询生产工序
     *
     * @param processId 生产工序主键
     * @return 生产工序
     */
    ProProcess selectProProcessByProcessId(Long processId);

    /**
     * 根据工序编码查询生产工序
     *
     * @param processCode 生产工序主键
     * @return 生产工序
     */
    @Select("select *from pro_process where process_code=#{processCode}")
    List<ProProcess> selectProProcessByProcessCode(@Param("processCode") String processCode);


    @Select("select *from pro_process where process_code=#{processCode}")
    ProProcess selectProProcessByProcessCodes(@Param("processCode") String processCode);

    @Select("select *from pro_process where process_name=#{processName}")
    ProProcess selectProProcessByProcessName(@Param("processName") String processName);

    /**
     * 查询生产工序列表
     *
     * @param proProcess 生产工序
     * @return 生产工序集合
     */
    List<ProProcess> selectProProcessList(ProProcess proProcess);


    ProProcess checkProcessCodeUnique(ProProcess proProcess);

    ProProcess checkProcessNameUnique(ProProcess proProcess);


    /**
     * 新增生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    int insertProProcess(ProProcess proProcess);

    /**
     * 修改生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    int updateProProcess(ProProcess proProcess);

    /**
     * 删除生产工序
     *
     * @param processId 生产工序主键
     * @return 结果
     */
    int deleteProProcessByProcessId(Long processId);

    /**
     * ep传mes删除生产工序
     *
     * @param processCode 生产工序主键
     * @return 结果
     */
    @Delete("delete from pro_process where process_code=#{processCode}")
    int deleteProProcessEpProcessCode(@Param("processCode") String processCode);

    /**
     * 批量删除生产工序
     *
     * @param processIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProProcessByProcessIds(Long[] processIds);

    @Select(value = "select * from pro_process  ${ew.customSqlSegment}")
    List<ProProcess> selectListByQw(@Param("ew") QueryWrapper<ProProcess> query);
}
