package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProArrange;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产编排单Mapper接口
 *
 * @author generator
 * @date 2024-03-01
 */
public interface ProArrangeMapper extends BaseMapper<ProArrange> {
    /**
     * 查询生产编排单
     *
     * @param arrangeId 生产编排单主键
     * @return 生产编排单
     */
    ProArrange selectProArrangeByArrangeId(Long arrangeId);

    ProArrange selectProArrangeByWorkorderId(Long workorderId);

    /**
     * 查询生产编排单列表
     *
     * @param proArrange 生产编排单
     * @return 生产编排单集合
     */
    List<ProArrange> selectProArrangeList(ProArrange proArrange);

    /**
     * 查询生产编排单列表
     *
     * @param proArrange 生产编排单
     * @return 生产编排单集合
     */

    @Select("select t1.*,t2.create_by,t2.create_time, COALESCE(t3.quantity, 0) quantity\n" +
            "from (SELECT arrange_code,\n" +
            "             GROUP_CONCAT(workorder_code SEPARATOR ',') AS workorder_code,\n" +
            "             GROUP_CONCAT(workorder_id SEPARATOR ',')   AS workorder_ids\n" +
            "      FROM pro_arrange\n" +
            "        ${ew.customSqlSegment} \n" +
            "      GROUP BY arrange_code) t1  left join (select distinct (arrange_code),arrange_id,create_time,create_by from pro_arrange " +
            "        ${ew.customSqlSegment} \n" +
            ") t2 on t1.arrange_code = t2.arrange_code\n" +
            "left join (select sum(quantity) quantity,arrange_code from pro_workorder group by arrange_code ) t3 on t1.arrange_code= t3.arrange_code")
    List<ProArrange> selectListGroupByQw(@Param("ew") QueryWrapper<ProArrange> query);

    ;


    /**
     * 新增生产编排单
     *
     * @param proArrange 生产编排单
     * @return 结果
     */
    int insertProArrange(ProArrange proArrange);

    /**
     * 修改生产编排单
     *
     * @param proArrange 生产编排单
     * @return 结果
     */
    int updateProArrange(ProArrange proArrange);

    /**
     * 删除生产编排单
     *
     * @param arrangeId 生产编排单主键
     * @return 结果
     */
    int deleteProArrangeByArrangeId(Long arrangeId);

    /**
     * 批量删除生产编排单
     *
     * @param arrangeIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProArrangeByArrangeIds(Long[] arrangeIds);


    /**
     * 根据工单批量删除生产编排单
     *
     * @param queryWrapper 需要删除的数据主键集合
     * @return 结果
     */
    @Delete(value = "delete from pro_arrange  ${ew.customSqlSegment}")
    void deleteProArrange(@Param("ew") QueryWrapper<ProArrange> queryWrapper);

    @Select("select t1.arrange_code,max(t1.create_time) create_time, max(t1.create_by) create_by  from pro_arrange t1 left join pro_workorder t2 on t1.arrange_code = t2.arrange_code ${ew.customSqlSegment} group by t1.arrange_code order by create_time desc")
    List<ProArrange> selectJoinWorkorderGroupByArrangeCode(@Param("ew") QueryWrapper<ProArrange> query);


    @Select("select  * from pro_arrange  ${ew.customSqlSegment} ")
    List<ProArrange> selectListByQw(@Param("ew") QueryWrapper<ProArrange> query);

    @Select("select t2.workorder_code,t1.* from (select t1.arrange_code,max(t1.create_time) create_time,max(t1.create_by) create_by from pro_arrange t1 group by t1.arrange_code) t1  inner join pro_workorder t2 on t1.arrange_code = t2.arrange_code   ${ew.customSqlSegment} ")
    List<ProArrange> selectDistictArrangeList(@Param("ew") QueryWrapper<ProArrange> query);
}
