package com.ximai.mes.pro.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DictionaryConverter;
import com.ximai.common.utils.excel.converter.DictionaryFormat;
import com.ximai.common.utils.excel.converter.StaticDataMappingConverter;
import com.ximai.common.utils.excel.converter.StaticDataMappingFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产工序对象 pro_process
 *
 * @date 2022-05-12
 */
@Data
public class ProProcessExcelExport
{
    private static final long serialVersionUID = 1L;

    /** 工序编码 */
    @ExcelProperty("工序编码")
    private String processCode;

    /** 工序名称 */
    @ExcelProperty("工序名称")
    private String processName;

    /** 工艺要求 */
    @ExcelProperty("工艺要求")
    private String attention;

    /** 是否启用 */
    @ExcelProperty(value="是否启用", converter = DictionaryConverter.class)
    @DictionaryFormat(dictType = "sys_yes_no")
    private String enableFlag;

    @ApiModelProperty("是否序列号报工,1:是，0:否")
    @ExcelProperty(value="序列号报工", converter = StaticDataMappingConverter.class)
    @StaticDataMappingFormat(value = {"1","0"}, excelValue = {"是","否"})
    private Integer isSerialReport;

    @ExcelProperty(value="备注")
    private String remark;
}
