package com.ximai.mes.pro.domain.vo.task;

import com.ximai.mes.pro.domain.vo.proWorkOrder.PackageReportInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 包装工序报工记录添加对象
 *
 * @date 2024-05-13
 */
@Data
public class FeedbackPackageAddParams {

    private Long workunidId;

    @ApiModelProperty("生产工单ID")
    private Long workorderId;

    @ApiModelProperty("生产任务ID")
    private Long taskId;

    @ApiModelProperty("包装数量")
    private Integer packNum;

    @ApiModelProperty("装箱数量")
    private Integer encasementNum;

    @ApiModelProperty("是否合并包装,1：是，0：否")
    private Integer mergePack;

    @ApiModelProperty("不良品数量")
    private BigDecimal quantityUnqualify;

    @ApiModelProperty("待检测数量")
    private BigDecimal quantityUncheck;

    @ApiModelProperty("报工用户名")
    private String userName;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("报工途径")
    private String feedbackChannel;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date feedbackTime;

    @ApiModelProperty("审批人员")
    private String recordUser;

    @ApiModelProperty("审批人员名称")
    private String recordNick;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("派工表ID")
    private Long taskWorkunitId;

    @ApiModelProperty("已入库数量")
    private BigDecimal quantityStorage;

    @ApiModelProperty("打印模板")
    private String printTemplate;

    @ApiModelProperty("报工数据")
    private PackageReportInfo reportData;

    /**
     * 包装数量、装箱数量、是否合并包装为NULL，都默认为0
     * 如果装箱数不为0，包装数量为0，包装数=装箱数量
     */
    public void initPackageValue(){
        if(this.getMergePack()==null){
            setMergePack(0);
        }
        if(this.getPackNum()==null){
            setPackNum(0);
        }
        if(this.getEncasementNum()==null){
            setEncasementNum(0);
        }
        if(this.getPackNum()==0&&this.getEncasementNum()!=0){
            setPackNum(this.getEncasementNum());
        }
    }

}
