package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 生产工单BOM对象 pro_work_order_bom
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
public class ProWorkOrderBomVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    @TableId
    private Long bomItemId;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private Long quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private Long scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Long alternativePriorities;

    /** 策略 */
    @Excel(name = "策略")
    private String alternativeStrategy;

    /** 使用概率 */
    @Excel(name = "使用概率")
    private Long alternativeProbability;

    /** BOM行备注 */
    private String bomItemRemark;

    /** 物料备注 */
    private String itemRemark;

    private String itemName;

    private String itemCode;

    /** 规格型号 */
    private String specification;

    /**
     * 是否倒冲
     */
    @Excel(name = "是否倒冲")
    private String isBackflush;



}
