package com.ximai.mes.pro.domain.task;

import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 报工包装标签打印记录表对象 pro_package_print_record
 *
 * @author generator
 * @date 2024-03-19
 */
@Data
public class ProPackagePrintRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    @TableId
    private Long recordId;

    /** 派工单ID */
    @Excel(name = "派工单ID")
    private Long taskWorkunitId;

    /** 工单ID */
    @Excel(name = "工单ID")
    private Long workorderId;

    /** 工单指令ID */
    @Excel(name = "工单指令ID")
    private Long workorderSoDirectiveId;

    /** 工单SIZE */
    @Excel(name = "工单SIZE")
    private Long workorderSoSizeItemId;

    /** 报工单ID */
    @Excel(name = "报工单ID")
    private Long feedbackId;

    /** 当前面码 */
    @ApiModelProperty("当前面码")
    private Integer sheetCount;

    @ApiModelProperty("打印标签值")
    private String barcode;

    @ApiModelProperty("二维码值")
    private String qrcode;

    @ApiModelProperty("总页码")
    private Integer totalCount;

    @ApiModelProperty("装箱数")
    private Integer packageNum;

    @ApiModelProperty("装箱数")
    private Integer packageNum2;

    @ApiModelProperty("LOSS数量")
    private Integer lossNum;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("箱重")
    private BigDecimal boxWeight;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

    @ApiModelProperty("打印人")
    private String printBy;

    @ApiModelProperty("打印时间")
    private Date printDate;

    @ApiModelProperty("小包总页码")
    private Integer minTotalCount;

    @ApiModelProperty("小包当前页码")
    private Integer minSheetCount;

    @ApiModelProperty("小包数量")
    private Integer minPackageNum;

    @ApiModelProperty("打印次数")
    private Integer printTime=0;

    @ApiModelProperty("bl分组号")
    private Integer blGroup;

    /** 工单指令ID集合，记录LOSS独立包装、混合包装标签 */
    @Excel(name = "工单SIZE集合，用,号分隔")
    private String workorderSoSizeItemIds;

    @ApiModelProperty("生产工单尺码表集合")
    private String workorderSoSizes;

    @ApiModelProperty("是否超报标签")
    private Integer isSurplus=0;

    @ApiModelProperty("装箱规格")
    private String packageStandard;

    @ApiModelProperty("体积")
    private String packVolume;

}
