package com.ximai.mes.pro.domain.sap;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 工装夹具清单对象 tm_tool
 *
 * @date 2022-05-11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SAPDtoTmToolBody extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @JSONField(name = "DATA")
    private List<SAPDtoTmTool> tmTools;

    //  SHKZG	过账方向	CHAR	1	0	过账到底是出库还是入库
    @JSONField(name = "I_SERNR")
    private List<SnBody> snBodies;

    @Data
    public static class SnBody {
        @JSONField(name = "MATNR")
        private String sapItemCode;
        // SERNR	序列号	CHAR	18	0	刀工模版具过账物料的序列号
        @JSONField(name = "SERNR")
        private String toolCode;
    }

    /**
     * 工装夹具清单对象 tm_tool
     *
     * @date 2022-05-11
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SAPDtoTmTool extends BaseEntity {
        private static final long serialVersionUID = 1L;

        /*
    MANDT	客户端	CLNT	3	0	发生的客户端
    MBLNR	物料凭证编号	CHAR	10	0	过账后的物料凭证
    MJAHR	凭证年份	NUMC	4	0	凭证年份
    ZEILE	凭证项次	NUMC	4	0	凭证项次
    XBLNR_MKPF	参考凭证编号	CHAR	16	0	过账凭证所参考的外部凭证编号
    CPUDT_MKPF	凭证创建日期	DATS	8	0	SAP执行过账的日期
    CPUTM_MKPF	凭证创建时刻	TIMS	6	0	SAP执行过账的时刻
    USNAM_MKPF	用户	CHAR	12	0	执行过账的SAP用户ID
    BWART	移动类型	CHAR	3	0	SAP过账的移动类型
    toolList
    MATNR	物料	CHAR	40	0	过账的刀工模版具物料编号
    MAKTX	物料品名	CHAR	40	0	过账的刀工模版具物料品名描述
    WERKS	工厂	CHAR	4	0	过账发生的工厂
    LGORT	库存地点	CHAR	4	0	过账发生的库存地点
    MENGE	数量	QUAN	13	3	领料/退回数量
    MEINS	单位	UNIT	3	0	数量单位
    KOSTL	成本中心	CHAR	4	0	领/退部门的成本中心
    WEMPF	收货人	CHAR	12	0	领/退部门的具体班组
    SHKZG	过账方向	CHAR	1	0	过账到底是出库还是入库
    SERNR	序列号	CHAR	18	0	刀工模版具过账物料的序列号
         */
        // MANDT	客户端	CLNT	3	0	发生的客户端
        @JSONField(name = "MANDT")
        private String client;
        @JSONField(name = "MBLNR")
        //  MBLNR	物料凭证编号	CHAR	10	0	过账后的物料凭证
        private String outboundOrderNo;

        @JSONField(name = "XBLNR_MKPF")
        // XBLNR_MKPF	参考凭证编号	CHAR	16	0	过账凭证所参考的外部凭证编号
        private String referenceVoucherNo;

        @JSONField(name = "ZEILE")
        // ZEILE	凭证项次	NUMC	4	0	凭证项次
        private String voucherItem;

        @JSONField(name = "CPUDT_MKPF")
        // CPUDT_MKPF	凭证创建日期	DATS	8	0	SAP执行过账的日期
        private String voucherCreateDay;

        @JSONField(name = "CPUTM_MKPF")
        // CPUTM_MKPF	凭证创建时刻	TIMS	6	0	SAP执行过账的时刻
        private String voucherCreateHour;

        @JSONField(name = "USNAM_MKPF")
        // USNAM_MKPF	用户	CHAR	12	0	执行过账的SAP用户ID
        private String username;
        @JSONField(name = "BWART")
        // BWART	移动类型	CHAR	3	0	SAP过账的移动类型
        private String sapMoveType;
        // 操作类型 update/insert/delete
        private String actionType;

        @JSONField(name = "MATNR")
        //MATNR	物料	CHAR	40	0	过账的刀工模版具物料编号
        private String sapItemCode;
        // 物料类型
        //    @JSONField(name = "MANDT")
        private String toolTypeCode;
        // 品牌
        //    @JSONField(name = "MANDT")
        private String brand;
        //        private String nextMaintenPeriod;
        //        private String maintenType;

        //  MAKTX	物料品名	CHAR	40	0	过账的刀工模版具物料品名描述
        @JSONField(name = "MAKTX")
        private String itemName;
        // WERKS	工厂	CHAR	4	0	过账发生的工厂
        @JSONField(name = "WERKS")
        private String workshop;
        // LGORT	库存地点	CHAR	4	0	过账发生的库存地点
        @JSONField(name = "LGORT")
        private String local;
        //MENGE	数量	QUAN	13	3	领料/退回数量
        @JSONField(name = "MENGE")
        private Long quantity;
        // MEINS	单位	UNIT	3	0	数量单位
        @JSONField(name = "MEINS")
        private String unit;
        // KOSTL	成本中心	CHAR	4	0	领/退部门的成本中心
        @JSONField(name = "KOSTL")
        private String costCenter;
        // WEMPF	收货人	CHAR	12	0	领/退部门的具体班组
        @JSONField(name = "WEMPF")
        private String consignee;
        //  SHKZG	过账方向	CHAR	1	0	过账到底是出库还是入库
        @JSONField(name = "SHKZG")
        private String postingDirection;

    }
}

