package com.ximai.mes.pro.domain.prototypeRequest;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 打样申请对象 pro_prototype_request
 *
 * @author zht
 * @date 2024-01-18
 */
    public class ProPrototypeRequest extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 样品申请单ID */
    @TableId
    private Long prototypeRequestId;

    /** 样品申请单编码 */
    @Excel(name = "样品申请单编码")
    private String prototypeRequestCode;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    @Excel(name = "产品名称")
    private transient String itemName;

    /** 工艺路线ID */
    @Excel(name = "工艺路线ID")
    private Long routeId;

    /** 工艺路线名称 */
    @Excel(name = "工艺路线名称")
    private transient String routeName;

    /** 简称 */
    @Excel(name = "简称")
    private String abbreviation;

    /** 样品英文名称 */
    @Excel(name = "样品英文名称")
    private String enName;

    /** 样品数量 */
    @Excel(name = "样品数量")
    private Long num;

    /** 打样形式 */
    @Excel(name = "打样形式")
    private String type;

    /** 分配方式 */
    @Excel(name = "分配方式")
    private String modality;

    /** 表面处理 */
    @Excel(name = "表面处理")
    private String surfaceTreatment;

    /** NG原因 */
    @Excel(name = "NG原因")
    private String ngReason;

    /** 计划完成日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划完成日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedFinishDate;

    /** 版面需求时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "版面需求时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date plannedLayoutDate;

    /** 申请单状态 */
    @Excel(name = "申请单状态")
    private int prototypeRequestStatus;

    /** 测试标准 */
    @Excel(name = "测试标准")
    private String testStandard;

    /** 长;单位cm */
    @Excel(name = "长;单位cm")
    private BigDecimal length;

    /** 宽;单位cm */
    @Excel(name = "宽;单位cm")
    private BigDecimal width;

    /** 高;单位cm */
    @Excel(name = "高;单位cm")
    private BigDecimal height;

    /** 厚度;单位mm */
    @Excel(name = "厚度;单位mm")
    private BigDecimal thick;

    /** 成品克重;单位g */
    @Excel(name = "成品克重;单位g")
    private BigDecimal weight;

    /** 角型 */
    @Excel(name = "角型")
    private String angleType;

    /**是否异型**/
    private String isAllotype;

    /**是否直角**/
    private String isRightAngle;

    /**圆角**/
    private BigDecimal fillet;

    /** 角度(单位mm) */
    @Excel(name = "角度(单位mm)")
    private BigDecimal angle;

    /** 孔径(单位mm) */
    @Excel(name = "孔径(单位mm)")
    private BigDecimal aperture;

    /** 单层厚(单位丝) */
    @Excel(name = "单层厚(单位丝)")
    private BigDecimal singleLayerThick;

    /** 单重(单位KG) */
    @Excel(name = "单重(单位KG)")
    private BigDecimal singleWeight;

    /** 层数 */
    @Excel(name = "层数")
    private BigDecimal layerNum;

    /** 是否防霉(is_open) */
    @Excel(name = "是否防霉(is_open)")
    private String isMould;

    /** 是否写码(is_open) */
    @Excel(name = "是否写码(is_open)")
    private String isCoding;

    /** 体系认证(product_sys_certification) */
    @Excel(name = "体系认证(product_sys_certification)")
    private String certification;

    /** 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角； */
    @Excel(name = "样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；")
    private String shape;

    /** 样品形状大小（mm） */
    @Excel(name = "样品形状大小", readConverterExp = "m=m")
    private BigDecimal shapeSize;

    /** 产品正面 */
    @Excel(name = "产品正面")
    private String frontImg;

    /** 产品背面 */
    @Excel(name = "产品背面")
    private String backImg;

    /** 印刷正面颜色 */
    @Excel(name = "印刷正面颜色")
    private Long frontColorId;

    /** 印刷反面颜色 */
    @Excel(name = "印刷反面颜色")
    private Long oppositeColorId;

    public Long getFrontColorId() {
        return frontColorId;
    }

    public void setFrontColorId(Long frontColorId) {
        this.frontColorId = frontColorId;
    }

    public Long getOppositeColorId() {
        return oppositeColorId;
    }

    public void setOppositeColorId(Long oppositeColorId) {
        this.oppositeColorId = oppositeColorId;
    }

    public String getFrontImg() {
        return frontImg;
    }

    public void setFrontImg(String frontImg) {
        this.frontImg = frontImg;
    }

    public String getBackImg() {
        return backImg;
    }

    public void setBackImg(String backImg) {
        this.backImg = backImg;
    }

    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getThick() {
        return thick;
    }

    public void setThick(BigDecimal thick) {
        this.thick = thick;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public String getAngleType() {
        return angleType;
    }

    public void setAngleType(String angleType) {
        this.angleType = angleType;
    }

    public String getIsAllotype() {
        return isAllotype;
    }

    public void setIsAllotype(String isAllotype) {
        this.isAllotype = isAllotype;
    }

    public String getIsRightAngle() {
        return isRightAngle;
    }

    public void setIsRightAngle(String isRightAngle) {
        this.isRightAngle = isRightAngle;
    }

    public BigDecimal getFillet() {
        return fillet;
    }

    public void setFillet(BigDecimal fillet) {
        this.fillet = fillet;
    }

    public BigDecimal getAngle() {
        return angle;
    }

    public void setAngle(BigDecimal angle) {
        this.angle = angle;
    }

    public BigDecimal getAperture() {
        return aperture;
    }

    public void setAperture(BigDecimal aperture) {
        this.aperture = aperture;
    }

    public BigDecimal getSingleLayerThick() {
        return singleLayerThick;
    }

    public void setSingleLayerThick(BigDecimal singleLayerThick) {
        this.singleLayerThick = singleLayerThick;
    }

    public BigDecimal getSingleWeight() {
        return singleWeight;
    }

    public void setSingleWeight(BigDecimal singleWeight) {
        this.singleWeight = singleWeight;
    }

    public BigDecimal getLayerNum() {
        return layerNum;
    }

    public void setLayerNum(BigDecimal layerNum) {
        this.layerNum = layerNum;
    }

    public String getIsMould() {
        return isMould;
    }

    public void setIsMould(String isMould) {
        this.isMould = isMould;
    }

    public String getIsCoding() {
        return isCoding;
    }

    public void setIsCoding(String isCoding) {
        this.isCoding = isCoding;
    }

    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }

    public String getShape() {
        return shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public BigDecimal getShapeSize() {
        return shapeSize;
    }

    public void setShapeSize(BigDecimal shapeSize) {
        this.shapeSize = shapeSize;
    }

    public String getRouteName() {
        return routeName;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setPrototypeRequestId(Long prototypeRequestId)
    {
        this.prototypeRequestId = prototypeRequestId;
    }

    public Long getPrototypeRequestId()
    {
        return prototypeRequestId;
    }
    public void setPrototypeRequestCode(String prototypeRequestCode)
    {
        this.prototypeRequestCode = prototypeRequestCode;
    }

    public String getPrototypeRequestCode()
    {
        return prototypeRequestCode;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setRouteId(Long routeId)
    {
        this.routeId = routeId;
    }

    public Long getRouteId()
    {
        return routeId;
    }
    public void setAbbreviation(String abbreviation)
    {
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation()
    {
        return abbreviation;
    }
    public void setEnName(String enName)
    {
        this.enName = enName;
    }

    public String getEnName()
    {
        return enName;
    }
    public void setNum(Long num)
    {
        this.num = num;
    }

    public Long getNum()
    {
        return num;
    }
    public void setType(String type)
    {
        this.type = type;
    }

    public String getType()
    {
        return type;
    }
    public void setModality(String modality)
    {
        this.modality = modality;
    }

    public String getModality()
    {
        return modality;
    }
    public void setSurfaceTreatment(String surfaceTreatment)
    {
        this.surfaceTreatment = surfaceTreatment;
    }

    public String getSurfaceTreatment()
    {
        return surfaceTreatment;
    }
    public void setNgReason(String ngReason)
    {
        this.ngReason = ngReason;
    }

    public String getNgReason()
    {
        return ngReason;
    }
    public void setPlannedFinishDate(Date plannedFinishDate)
    {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Date getPlannedFinishDate()
    {
        return plannedFinishDate;
    }
    public void setPlannedLayoutDate(Date plannedLayoutDate)
    {
        this.plannedLayoutDate = plannedLayoutDate;
    }

    public Date getPlannedLayoutDate()
    {
        return plannedLayoutDate;
    }

    public int getPrototypeRequestStatus() {
        return prototypeRequestStatus;
    }

    public void setPrototypeRequestStatus(int prototypeRequestStatus) {
        this.prototypeRequestStatus = prototypeRequestStatus;
    }

    public void setTestStandard(String testStandard)
    {
        this.testStandard = testStandard;
    }

    public String getTestStandard()
    {
        return testStandard;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("prototypeRequestId", getPrototypeRequestId())
            .append("prototypeRequestCode", getPrototypeRequestCode())
            .append("productId", getItemId())
            .append("routeId", getRouteId())
            .append("abbreviation", getAbbreviation())
            .append("enName", getEnName())
            .append("num", getNum())
            .append("type", getType())
            .append("modality", getModality())
            .append("surfaceTreatment", getSurfaceTreatment())
            .append("ngReason", getNgReason())
            .append("plannedFinishDate", getPlannedFinishDate())
            .append("plannedLayoutDate", getPlannedLayoutDate())
            .append("status", getPrototypeRequestStatus())
            .append("testStandard", getTestStandard())
            .append("remark", getRemark())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
