package com.ximai.mes.pro.controller.productionMake;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionMake.ProProductionMake;
import com.ximai.mes.pro.domain.vo.ProProductionMakeVo;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 量产制作Controller
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionMake")
public class ProProductionMakeController extends BaseController {
    @Autowired
    private IProProductionMakeService proProductionMakeService;

    /**
     * 查询量产制作列表
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMake:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionMake proProductionMake) {
        startPage();
        List<ProProductionMakeVo> list = proProductionMakeService.selectProProductionMakeList(proProductionMake);
        return getDataTable(list);
    }
    /**
     * 获取量产制作详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMake:query')")
    @GetMapping(value = "/{productionMakeId}")
    public AjaxResult getInfo(@PathVariable("productionMakeId") Long productionMakeId) {
        return AjaxResult.success(proProductionMakeService.selectProProductionMakeByProductionMakeId(productionMakeId));
    }

    /**
     * 新增量产制作
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMake:add')")
    @Log(title = "量产制作", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionMakeVo proProductionMakeVo) {
        return toAjax(proProductionMakeService.insertProProductionMake(proProductionMakeVo));
    }

    /**
     * 修改量产制作
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMake:edit')")
    @Log(title = "量产制作", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionMakeVo proProductionMake) {
        return toAjax(proProductionMakeService.updateProProductionMake(proProductionMake));
    }

    /**
     * 删除量产制作
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMake:remove')")
    @Log(title = "量产制作", businessType = BusinessType.DELETE)
    @DeleteMapping("/{productionMakeIds}")
    public AjaxResult remove(@PathVariable Long[] productionMakeIds) {
        return toAjax(proProductionMakeService.deleteProProductionMakeByProductionMakeIds(productionMakeIds));
    }

    /**
     * 状态修改
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:edit')")
    @Log(title = "量产制作单", businessType = BusinessType.UPDATE)
    @PutMapping("/modifyState")
    public AjaxResult editStatus(@RequestBody ProProductionMake proProductionMake) {
        return toAjax(proProductionMakeService.updateProProductionMakeStatus(proProductionMake));
    }
}
