package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.ProWorkstationMaterialVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProWorkstationMaterial;
import com.ximai.mes.pro.service.IProWorkstationMaterialService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 工作中心发料申请Controller
 *
 * @author generator
 * @date 2024-07-26
 */
@RestController
@RequestMapping("/pro/material")
public class ProWorkstationMaterialController extends BaseController
{
    @Autowired
    private IProWorkstationMaterialService proWorkstationMaterialService;

    /**
     * 查询工作中心发料申请列表
     */
    @PreAuthorize("@ss.hasPermi('pro:material:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkstationMaterialVo proWorkstationMaterial)
    {
        startPage();
        List<ProWorkstationMaterialVo> list = proWorkstationMaterialService.selectProWorkstationMaterialList(proWorkstationMaterial);
        return getDataTable(list);
    }

    /**
     * 导出工作中心发料申请列表
     */
    @PreAuthorize("@ss.hasPermi('pro:material:export')")
    @Log(title = "工作中心发料申请", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkstationMaterial proWorkstationMaterial)
    {
//        List<ProWorkstationMaterial> list = proWorkstationMaterialService.selectProWorkstationMaterialList(proWorkstationMaterial);
//        ExcelUtil<ProWorkstationMaterial> util = new ExcelUtil<ProWorkstationMaterial>(ProWorkstationMaterial.class);
//        util.exportExcel(response, list, "工作中心发料申请数据");
    }

    /**
     * 获取工作中心发料申请详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:material:query')")
    @GetMapping(value = "/{workstationMaterialId}")
    public AjaxResult getInfo(@PathVariable("workstationMaterialId") Long workstationMaterialId)
    {
        return AjaxResult.success(proWorkstationMaterialService.selectProWorkstationMaterialByWorkstationMaterialId(workstationMaterialId));
    }

    /**
     * 新增工作中心发料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:material:add')")
    @Log(title = "工作中心发料申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkstationMaterial proWorkstationMaterial)
    {
        return toAjax(proWorkstationMaterialService.insertProWorkstationMaterial(proWorkstationMaterial));
    }

    /**
     * 修改工作中心发料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:material:edit')")
    @Log(title = "工作中心发料申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkstationMaterial proWorkstationMaterial)
    {
        return toAjax(proWorkstationMaterialService.updateProWorkstationMaterial(proWorkstationMaterial));
    }

    /**
     * 删除工作中心发料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:material:remove')")
    @Log(title = "工作中心发料申请", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workstationMaterialIds}")
    public AjaxResult remove(@PathVariable Long[] workstationMaterialIds)
    {
        return toAjax(proWorkstationMaterialService.deleteProWorkstationMaterialByWorkstationMaterialIds(workstationMaterialIds));
    }
}
