package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.common.constant.UserConstants;
import com.ximai.mes.wm.utils.WmBarCodeUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProTransOrder;
import com.ximai.mes.pro.service.IProTransOrderService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 流转单Controller
 *
 * @date 2022-07-24
 */
@RestController
@RequestMapping("/mes/pro/transorder")
public class ProTransOrderController extends BaseController
{
    @Autowired
    private IProTransOrderService proTransOrderService;

    @Autowired
    private WmBarCodeUtil wmBarCodeUtil;

    /**
     * 查询流转单列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ProTransOrder proTransOrder)
    {
        startPage();
        List<ProTransOrder> list = proTransOrderService.selectProTransOrderList(proTransOrder);
        return getDataTable(list);
    }


    /**
     * 获取流转单详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:transorder:query')")
    @GetMapping(value = "/{transOrderId}")
    public AjaxResult getInfo(@PathVariable("transOrderId") Long transOrderId)
    {
        return AjaxResult.success(proTransOrderService.selectProTransOrderByTransOrderId(transOrderId));
    }

    /**
     * 新增流转单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:transorder:add')")
    @Log(title = "流转单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProTransOrder proTransOrder)
    {
        proTransOrderService.insertProTransOrder(proTransOrder);
        wmBarCodeUtil.generateBarCode(UserConstants.BARCODE_TYPE_TRANSORDER,proTransOrder.getTransOrderId(),proTransOrder.getTransOrderCode(),null);
        proTransOrder.setCreateBy(getUsername());
        return AjaxResult.success(proTransOrder.getTransOrderId());
    }

    /**
     * 修改流转单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:transorder:edit')")
    @Log(title = "流转单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProTransOrder proTransOrder)
    {
        return toAjax(proTransOrderService.updateProTransOrder(proTransOrder));
    }

    /**
     * 删除流转单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:transorder:remove')")
    @Log(title = "流转单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{transOrderIds}")
    public AjaxResult remove(@PathVariable Long[] transOrderIds)
    {
        return toAjax(proTransOrderService.deleteProTransOrderByTransOrderIds(transOrderIds));
    }
}
