package com.ximai.mes.od.vo;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @since created by hyy on 2024-01-23
 */
@Data
public class PurchaseOrderDto {

    /**
     * 产品ID
     */
    private Long productId;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 客户单号
     */
    private String customerNo;

    /**
     * 客户产品代码
     */
    private String customerCode;
    /**
     * 宝绅内部品名
     */
    private String customerName;
    /**
     * 客户产品名称
     */
    private String customerProductName;
    /**
     * 客户单位
     */
    private String customerUnit;
    /**
     * 指令号
     */
    private String instruct;
    /**
     * 型体号
     */
    private String typeNumber;
    /**
     * 配色号
     */
    private String colorCode;
    /**
     * 产地
     */
    private String region;
    /**
     * 客户颜色
     */
    private String color;
    /**
     * 客户单重
     */
    private String weight;
    /**
     * 销线
     */
    private String salesLine;
    /**
     * 段别
     */
    private String dan;
    /**
     * 版面
     */
    private String face;
    /**
     * 季度
     */
    private String quarter;
    /**
     * 整/半码
     */
    private String half;
    /**
     * 特殊SIZE
     */
    private String specialSize;
    /**
     * PO号
     */
    private String poCode;
    /**
     * WIP号
     */
    private String wipCode;
    /**
     * 装箱数
     */
    private String Packing;
    /**
     * 产地
     */
    private String producer;
    /**
     * 周期
     */
    private String cycle;
    /**
     * SK编号
     */
    private String skNo;
    /**
     * 专利号
     */
    private String patentNumber;
    /**
     * 材质描述
     */
    private String materialDesc;
    /**
     * 签收人
     */
    private String signee;
    /**
     * SHIP TO ID
     */
    private String shipTOId;
    /**
     * 交货日期
     */
    private Date DeliveryDate;

    /**
     * 备注
     */
    private String remark;
    /**
     * 尺码组
     */
    private String sizeGroup;
    /**
     * 尺码
     */
    private String size;
    /**
     * 订单量
     */
    private Integer orderNumber;
    /**
     * 条码
     */
    private String barCode;
    /**
     * 印刷方向
     */
    private String printDirection;
    /**
     * 产品规格
     */
    private String productSpecifications;
    /**
     * 申购/采购单号
     */
    private String buyCode;
    /**
     * 原文件名
     */
    private String filePath;

    /**
     * 订单详情
     */
    private List<ItemSpec> productProperties;

    @Getter
    @Setter
    @ToString
    public static class ItemSpec {

        /**
         * 产品特性配置标题
         */
        private String productPropertiesTitle;

        /**
         * 产品特性值
         */
        private String productPropertiesValue;
    }

    public static Map<String, String> convert(ItemSpec itemSpec) {
        Map<String, String> map = new HashMap<>();
        map.put("specKey", itemSpec.getProductPropertiesTitle());
        map.put("specVal", itemSpec.getProductPropertiesValue());
        return map;
    }
}
