package com.ximai.mes.od.service;

import com.ximai.mes.od.domain.OdPurchaseOrder;
import com.ximai.mes.od.domain.OdSalesOrder;
import com.ximai.mes.od.vo.PurchaseOrderDto;

import java.util.List;

/**
 * 客户采购订单Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IOdPurchaseOrderService {

    /**
     * 查询客户采购订单列表
     *
     * @param odPurchaseOrder 客户采购订单
     * @return 客户采购订单集合
     */
    List<OdPurchaseOrder> selectOdPurchaseOrderList(OdPurchaseOrder odPurchaseOrder);

    /**
     * 新增客户采购订单
     *
     * @param odPurchaseOrder 客户采购订单
     * @return 结果
     */
    int insertOdPurchaseOrder(OdPurchaseOrder odPurchaseOrder);


    /**
     * 批量删除客户采购订单
     *
     * @param ids 需要删除的客户采购订单主键集合
     * @return 结果
     */
    int deleteOdPurchaseOrderByIds(String[] ids);

    /**
     * 批量插入客户采购订单
     */
    int batchInsert(List<PurchaseOrderDto> odPurchaseOrder);

    int batchSave(List<PurchaseOrderDto> odPurchaseOrder);

    /**
     * 通过客户采购订单获取公司销售订单
     */
    OdSalesOrder getSalesOrder(Long id);
}
