package com.ximai.mes.od.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 销售订单详情对象 od_sales_order_detail
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Data
public class OdSalesOrderDetail extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private Long id;

    /**
     * 订单id
     */
    @Excel(name = "订单id")
    private Long orderId;


    /**
     * 订单编码
     */
    @Excel(name = "订单编码")
    private String orderNo;

    /**
     * 产品id
     */
    @Excel(name = "产品id")
    private Long itemId;

    /**
     * 产品代码
     */
    @Excel(name = "产品代码")
    private String itemNo;

    /**
     * 产品代码
     */
    @Excel(name = "产品代码")
    private String sapItemNo;

    /**
     * 产品名称
     */
    @Excel(name = "产品名称")
    private String itemName;

    /**
     * 总数量(num + loss_num)
     */
    @Excel(name = "总数量(num + loss_num)")
    private Integer totalNum;

    /**
     * 数量
     */
    @Excel(name = "数量")
    private Integer num;

    /**
     * loss数量
     */
    @Excel(name = "loss数量")
    private Integer lossNum;

    /**
     * 单价
     */
    @Excel(name = "单价")
    private BigDecimal price;

    /**
     * 装运点
     */
    @Excel(name = "装运点")
    private String shipmentPointNo;

    /**
     * 存储地点
     */
    @Excel(name = "存储地点")
    private String storeAddr;

    /**
     * 批次号
     */
    @Excel(name = "批次号")
    private String batchNo;

    /**
     * 实际交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实际交货日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date actualDeliveryDate;

    /**
     * 定价值
     */
    @Excel(name = "定价值")
    private String pricingVal;

    /**
     * 报价单位(和客户确定价格的单位)
     */
    @Excel(name = "报价单位(和客户确定价格的单位)")
    private String offerUnit;

    /**
     * 销售单位(销售订单行数量的单位)
     */
    @Excel(name = "销售单位(销售订单行数量的单位)")
    private String saleUnit;

    /**
     * 尺码单位
     */
    @Excel(name = "尺码单位")
    private String sizeUnit;

    /**
     * 客户订单号
     */
    @Excel(name = "客户订单号")
    private String poOrderNo;

    /**
     * 客户产品代码
     */
    @Excel(name = "客户产品代码")
    private String clientItemNo;

    /**
     * 客户产品名称
     */
    @Excel(name = "客户产品名称")
    private String clientItemName;

    /**
     * 客户尺码单位
     */
    @Excel(name = "客户尺码单位")
    private String clientSizeUnit;

    /**
     * 客户指令号
     */
    @Excel(name = "客户指令号")
    private String clientCmd;

    /**
     * 销售工厂
     */
    @Excel(name = "销售工厂")
    private String saleFactory;

    /**
     * 型体号
     */
    @Excel(name = "型体号")
    private String typeNo;

    /**
     * 配色号
     */
    @Excel(name = "配色号")
    private String colorNo;

    /**
     * 颜色
     */
    @Excel(name = "颜色")
    private String color;

    /**
     * 客户单重
     */
    @Excel(name = "客户单重")
    private String clientKg;

    /**
     * 销线
     */
    @Excel(name = "销线")
    private String salePath;

    /**
     * 段别
     */
    @Excel(name = "段别")
    private String segment;

    /**
     * 版面
     */
    @Excel(name = "版面")
    private String layout;

    /**
     * 季度
     */
    @Excel(name = "季度")
    private String quarter;

    /**
     * 整/半码
     */
    @Excel(name = "整/半码")
    private String wholeSize;

    /**
     * 特殊尺码
     */
    @Excel(name = "特殊尺码")
    private String specSize;

    /**
     * po_no
     */
    @Excel(name = "po_no")
    private String poNo;

    /**
     * wip_no
     */
    @Excel(name = "wip_no")
    private String wipNo;

    /**
     * 装箱数
     */
    @Excel(name = "装箱数")
    private String packingNum;

    /**
     * 周期
     */
    @Excel(name = "周期")
    private String cycle;

    /**
     * sk_no
     */
    @Excel(name = "sk_no")
    private String skNo;

    /**
     * 专利号
     */
    @Excel(name = "专利号")
    private String patentNo;

    /**
     * 材质描述
     */
    @Excel(name = "材质描述")
    private String materialDesc;

    /**
     * 签收人
     */
    @Excel(name = "签收人")
    private String signer;

    /**
     * ship_to_id
     */
    @Excel(name = "ship_to_id")
    private String shipToId;

    /**
     * 交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "交货日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date deliveryDate;

    /**
     * 尺码组
     */
    @Excel(name = "尺码组")
    private String sizeGroup;

    /**
     * 尺码
     */
    @Excel(name = "尺码")
    private String size;

    /**
     * 订单量
     */
    @Excel(name = "订单量")
    private Integer orderNum;

    /**
     * 条码
     */
    @Excel(name = "条码")
    private String barCode;

    /**
     * 印刷方向
     */
    @Excel(name = "印刷方向")
    private String printingDirection;

    /**
     * 产品规格
     */
    @Excel(name = "产品规格")
    private String prodSpec;

    /**
     * 客户工厂代号
     */
    @Excel(name = "客户工厂代号")
    private String plantCode;

    /**
     * 包装方式
     */
    @Excel(name = "包装方式")
    private String packMode;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String state;

    private List<OdSalesOrderDetailItem> itemList;

}
