package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSalesClauseMapper;
import com.ximai.mes.md.domain.MdSalesClause;
import com.ximai.mes.md.service.IMdSalesClauseService;

/**
 * 国际贸易销售条款Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSalesClauseServiceImpl implements IMdSalesClauseService
{
    @Autowired
    private MdSalesClauseMapper mdSalesClauseMapper;

    /**
     * 查询国际贸易销售条款
     *
     * @param id 国际贸易销售条款主键
     * @return 国际贸易销售条款
     */
    @Override
    public MdSalesClause selectMdSalesClauseById(String id)
    {
        return mdSalesClauseMapper.selectMdSalesClauseById(id);
    }

    /**
     * 查询国际贸易销售条款列表
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 国际贸易销售条款
     */
    @Override
    public List<MdSalesClause> selectMdSalesClauseList(MdSalesClause mdSalesClause)
    {
        return mdSalesClauseMapper.selectMdSalesClauseList(mdSalesClause);
    }

    /**
     * 新增国际贸易销售条款
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 结果
     */
    @Override
    public int insertMdSalesClause(MdSalesClause mdSalesClause)
    {
        mdSalesClause.setCreateTime(DateUtils.getNowDate());
        return mdSalesClauseMapper.insertMdSalesClause(mdSalesClause);
    }

    /**
     * 修改国际贸易销售条款
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 结果
     */
    @Override
    public int updateMdSalesClause(MdSalesClause mdSalesClause)
    {
        mdSalesClause.setUpdateTime(DateUtils.getNowDate());
        return mdSalesClauseMapper.updateMdSalesClause(mdSalesClause);
    }

    /**
     * 批量删除国际贸易销售条款
     *
     * @param ids 需要删除的国际贸易销售条款主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesClauseByIds(String[] ids)
    {
        return mdSalesClauseMapper.deleteMdSalesClauseByIds(ids);
    }

    /**
     * 删除国际贸易销售条款信息
     *
     * @param id 国际贸易销售条款主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesClauseById(String id)
    {
        return mdSalesClauseMapper.deleteMdSalesClauseById(id);
    }
}
