package com.ximai.mes.md.service.impl;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.mapper.MdItemWarehouseMapper;
import com.ximai.mes.md.domain.MdItemWarehouse;
import com.ximai.mes.md.dto.MdItemWarehouseCreate;
import com.ximai.mes.md.dto.MdItemWarehouseUpdate;
import com.ximai.mes.md.dto.MdItemWarehouseDto;
import com.ximai.mes.md.service.IMdItemWarehouseService;

/**
 * 物料仓库Service业务层处理
 *
 * @author generator
 * @date 2024-10-20
 */
@Service
public class MdItemWarehouseServiceImpl implements IMdItemWarehouseService
{
    @Autowired
    private MdItemWarehouseMapper mdItemWarehouseMapper;

    /**
     * 查询物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 物料仓库
     */
    @Override
    public MdItemWarehouseDto selectMdItemWarehouseDtoByItemWarehouseId(Long itemWarehouseId) {
        return mdItemWarehouseMapper.selectMdItemWarehouseByItemWarehouseId(itemWarehouseId);
    }

    /**
     * 查询物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 物料仓库
     */
    @Override
    public MdItemWarehouse selectMdItemWarehouseByItemWarehouseId(Long itemWarehouseId) {
        return mdItemWarehouseMapper.selectById(itemWarehouseId);
    }

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouse 物料仓库
     * @return 物料仓库
     */
    @Override
    public List<MdItemWarehouseDto> selectMdItemWarehouseList(MdItemWarehouse mdItemWarehouse) {
        return mdItemWarehouseMapper.selectMdItemWarehouseList(mdItemWarehouse);
    }

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouseQuery 物料仓库
     * @return 物料仓库
     */
    @Override
    public List<MdItemWarehouse> selectMdItemWarehouseList(QueryWrapper<MdItemWarehouse> mdItemWarehouseQuery) {
        return mdItemWarehouseMapper.selectList(mdItemWarehouseQuery);
    }

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouseQuery 物料仓库
     * @return 物料仓库
     */
    @Override
    public List<MdItemWarehouseDto> selectMdItemWarehouseDtoList(QueryWrapper<MdItemWarehouse> mdItemWarehouseQuery) {
        return mdItemWarehouseMapper.selectDtoListByQw(mdItemWarehouseQuery);
    }

    /**
     * 新增物料仓库
     *
     * @param mdItemWarehouseCreate 物料仓库
     * @return 结果
     */
    @Override
    public int insertMdItemWarehouse(MdItemWarehouseCreate mdItemWarehouseCreate) {

        MdItemWarehouse mdItemWarehouse = new MdItemWarehouse();
        BeanUtil.copyProperties(mdItemWarehouseCreate, mdItemWarehouse);
        mdItemWarehouse.createAction();
        return mdItemWarehouseMapper.insertMdItemWarehouse(mdItemWarehouse);
    }

    /**
     * 修改物料仓库
     *
     * @param mdItemWarehouseUpdate 物料仓库
     * @return 结果
     */
    @Override
    public int updateMdItemWarehouse(MdItemWarehouseUpdate mdItemWarehouseUpdate) {
        MdItemWarehouse mdItemWarehouse = new MdItemWarehouse();
        BeanUtil.copyProperties(mdItemWarehouseUpdate, mdItemWarehouse);
        mdItemWarehouse.updateAction();
        return mdItemWarehouseMapper.updateMdItemWarehouse(mdItemWarehouse);
    }

    /**
     * 批量删除物料仓库
     *
     * @param itemWarehouseIds 需要删除的物料仓库主键
     * @return 结果
     */
    @Override
    public int deleteMdItemWarehouseByItemWarehouseIds(Long[] itemWarehouseIds) {
        return mdItemWarehouseMapper.deleteMdItemWarehouseByItemWarehouseIds(itemWarehouseIds);
    }

    /**
     * 删除物料仓库信息
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 结果
     */
    @Override
    public int deleteMdItemWarehouseByItemWarehouseId(Long itemWarehouseId) {
        return mdItemWarehouseMapper.deleteMdItemWarehouseByItemWarehouseId(itemWarehouseId);
    }
}
