package com.ximai.mes.md.service.impl;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ximai.mes.md.mapper.MdClientAccountMapper;
import com.ximai.mes.md.domain.MdClientAccount;
import com.ximai.mes.md.service.IMdClientAccountService;

/**
 * 客户付款信息Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
@AllArgsConstructor
public class MdClientAccountServiceImpl extends ServiceImpl<MdClientAccountMapper, MdClientAccount> implements IMdClientAccountService {


    @Override
    public IPage<MdClientAccount> page(Map<String, Object> params) {
        final Integer pageNum = MapUtil.getInt(params, "pageNum");
        final Integer pageSize = MapUtil.getInt(params, "pageSize");
        return baseMapper.pageByMap(new Page<>(pageNum, pageSize), params);
    }

    @Override
    public MdClientAccount selectById(Long id) {
        return getById(id);
    }

    @Override
    public List<MdClientAccount> selectList(MdClientAccount mdClientAccount) {
        QueryWrapper<MdClientAccount> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("client_code",mdClientAccount.getClientCode());
        return list(queryWrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean insert(MdClientAccount mdClientAccount) {
        mdClientAccount.setCreateTime(DateUtils.getNowDate());
        return save(mdClientAccount);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean update(MdClientAccount mdClientAccount) {
        mdClientAccount.setUpdateTime(DateUtils.getNowDate());
        return updateById(mdClientAccount);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteByIds(List<Long> ids) {
        return removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteById(Long id) {
        return removeById(id);
    }

}
