package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleOrderChannel;

/**
 * 销售订单分销渠道Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IMdSaleOrderChannelService
{
    /**
     * 查询销售订单分销渠道
     *
     * @param id 销售订单分销渠道主键
     * @return 销售订单分销渠道
     */
    public MdSaleOrderChannel selectMdSaleOrderChannelById(Long id);

    /**
     * 查询销售订单分销渠道列表
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 销售订单分销渠道集合
     */
    public List<MdSaleOrderChannel> selectMdSaleOrderChannelList(MdSaleOrderChannel mdSaleOrderChannel);

    /**
     * 新增销售订单分销渠道
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 结果
     */
    public int insertMdSaleOrderChannel(MdSaleOrderChannel mdSaleOrderChannel);

    /**
     * 修改销售订单分销渠道
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 结果
     */
    public int updateMdSaleOrderChannel(MdSaleOrderChannel mdSaleOrderChannel);

    /**
     * 批量删除销售订单分销渠道
     *
     * @param ids 需要删除的销售订单分销渠道主键集合
     * @return 结果
     */
    public int deleteMdSaleOrderChannelByIds(Long[] ids);

    /**
     * 删除销售订单分销渠道信息
     *
     * @param id 销售订单分销渠道主键
     * @return 结果
     */
    public int deleteMdSaleOrderChannelById(Long id);
}
