package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSalesClause;

/**
 * 国际贸易销售条款Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSalesClauseMapper
{
    /**
     * 查询国际贸易销售条款
     *
     * @param id 国际贸易销售条款主键
     * @return 国际贸易销售条款
     */
    public MdSalesClause selectMdSalesClauseById(String id);

    /**
     * 查询国际贸易销售条款列表
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 国际贸易销售条款集合
     */
    public List<MdSalesClause> selectMdSalesClauseList(MdSalesClause mdSalesClause);

    /**
     * 新增国际贸易销售条款
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 结果
     */
    public int insertMdSalesClause(MdSalesClause mdSalesClause);

    /**
     * 修改国际贸易销售条款
     *
     * @param mdSalesClause 国际贸易销售条款
     * @return 结果
     */
    public int updateMdSalesClause(MdSalesClause mdSalesClause);

    /**
     * 删除国际贸易销售条款
     *
     * @param id 国际贸易销售条款主键
     * @return 结果
     */
    public int deleteMdSalesClauseById(String id);

    /**
     * 批量删除国际贸易销售条款
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSalesClauseByIds(String[] ids);
}
