package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 品牌联系人对象 md_brand_contact
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public class MdBrandContact extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long brandContactId;

    /** 品牌id */
    private Long brandId;

    /** 品牌编码*/
    @Excel(name = "品牌编码")
    private String brandCode;

    /** 品牌名称*/
    @Excel(name = "品牌名称")
    private String brandName;

    /** 联系人 */
    @Excel(name = "联系人")
    private String contactName;

    /** 联系人(英文名) */
    @Excel(name = "联系人(英文名)")
    private String contactNameEn;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String contactPhone;

    /** 办公区域 */
    @Excel(name = "办公区域")
    private String officeArea;

    /** 部门 */
    @Excel(name = "部门")
    private String department;

    /** 职位 */
    @Excel(name = "职位")
    private String position;

    /** 邮箱地址 */
    @Excel(name = "邮箱地址")
    private String mailbox;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    public void setBrandContactId(Long brandContactId)
    {
        this.brandContactId = brandContactId;
    }

    public Long getBrandContactId()
    {
        return brandContactId;
    }
    public void setBrandId(Long brandId)
    {
        this.brandId = brandId;
    }

    public Long getBrandId()
    {
        return brandId;
    }
    public void setContactName(String contactName)
    {
        this.contactName = contactName;
    }

    public String getContactName()
    {
        return contactName;
    }
    public void setContactNameEn(String contactNameEn)
    {
        this.contactNameEn = contactNameEn;
    }

    public String getContactNameEn()
    {
        return contactNameEn;
    }
    public void setContactPhone(String contactPhone)
    {
        this.contactPhone = contactPhone;
    }

    public String getContactPhone()
    {
        return contactPhone;
    }
    public void setOfficeArea(String officeArea)
    {
        this.officeArea = officeArea;
    }

    public String getOfficeArea()
    {
        return officeArea;
    }
    public void setDepartment(String department)
    {
        this.department = department;
    }

    public String getDepartment()
    {
        return department;
    }
    public void setPosition(String position)
    {
        this.position = position;
    }

    public String getPosition()
    {
        return position;
    }
    public void setMailbox(String mailbox)
    {
        this.mailbox = mailbox;
    }

    public String getMailbox()
    {
        return mailbox;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("brandContactId", getBrandContactId())
                .append("brandId", getBrandId())
                .append("brandCode", getBrandCode())
                .append("brandName", getBrandName())
                .append("contactName", getContactName())
                .append("contactNameEn", getContactNameEn())
                .append("contactPhone", getContactPhone())
                .append("officeArea", getOfficeArea())
                .append("department", getDepartment())
                .append("position", getPosition())
                .append("mailbox", getMailbox())
                .append("remark", getRemark())
                .append("enableFlag", getEnableFlag())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }
}
