package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleOrderOffice;
import com.ximai.mes.md.service.IMdSaleOrderOfficeService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单办事处Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/office")
public class MdSaleOrderOfficeController extends BaseController
{
    @Autowired
    private IMdSaleOrderOfficeService mdSaleOrderOfficeService;

    /**
     * 查询销售订单办事处列表
     */
    @PreAuthorize("@ss.hasPermi('md:office:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleOrderOffice mdSaleOrderOffice)
    {
        startPage();
        List<MdSaleOrderOffice> list = mdSaleOrderOfficeService.selectMdSaleOrderOfficeList(mdSaleOrderOffice);
        return getDataTable(list);
    }

    /**
     * 获取销售订单办事处详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:office:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleOrderOfficeService.selectMdSaleOrderOfficeById(id));
    }

    /**
     * 新增销售订单办事处
     */
    @PreAuthorize("@ss.hasPermi('md:office:add')")
    @Log(title = "销售订单办事处", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleOrderOffice mdSaleOrderOffice)
    {
        return toAjax(mdSaleOrderOfficeService.insertMdSaleOrderOffice(mdSaleOrderOffice));
    }

    /**
     * 修改销售订单办事处
     */
    @PreAuthorize("@ss.hasPermi('md:office:edit')")
    @Log(title = "销售订单办事处", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleOrderOffice mdSaleOrderOffice)
    {
        return toAjax(mdSaleOrderOfficeService.updateMdSaleOrderOffice(mdSaleOrderOffice));
    }

    /**
     * 删除销售订单办事处
     */
    @PreAuthorize("@ss.hasPermi('md:office:remove')")
    @Log(title = "销售订单办事处", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleOrderOfficeService.deleteMdSaleOrderOfficeByIds(ids));
    }
}
