package com.ximai.mes.kanban.dto.abnormal;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
public class AbnormalMonthStatDto {

    @ApiModelProperty("生产异常")
    AbnormalMonthStatDetail productAbnormal;

    @ApiModelProperty("设备异常")
    AbnormalMonthStatDetail equipAbnormal;

    @ApiModelProperty("设备正常数")
    Integer equipCt;

    @ApiModelProperty("当前设备故障数")
    Integer equipErrorCt;

    @ApiModelProperty("设备近七天故障数，顺序为：索引0当天、1昨天、2前天")
    List<Integer> equipErrorArr=new ArrayList<>();

    @Data
    public static class AbnormalMonthStatDetail{
        @ApiModelProperty("异常总数")
        Integer totalCt=0;
        @ApiModelProperty("未关闭数")
        Integer unCloseCt=0;
        @ApiModelProperty("超期未关闭数")
        Integer expireUnClose=0;
    }

}
