package com.ximai.mes.cal.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.cal.domain.CalWorkunit;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 计划工作单元Mapper接口
 *
 * @author generator
 * @date 2024-03-14
 */
public interface CalWorkunitMapper extends BaseMapper<CalWorkunit> {
    /**
     * 查询计划工作单元
     *
     * @param id 计划工作单元主键
     * @return 计划工作单元
     */
    CalWorkunit selectCalWorkunitById(Long id);

    /**
     * 查询计划工作单元列表
     *
     * @param calWorkunit 计划工作单元
     * @return 计划工作单元集合
     */
    List<CalWorkunit> selectCalWorkunitList(CalWorkunit calWorkunit);


    /**
     * 关联工作中心查询作业单元列表
     *
     * @param query
     * @return
     */
    @Select("select t1.*,t2.workstation_id,t2.workstation_code,t3.workstation_name,t4.workshop_id,t4.workshop_code,t4.workshop_name,t5.factory_id,t5.factory_code,t5.factory_name from cal_workunit t1 inner join md_workunit t2 on t1.workunit_id = t2.workunit_id  inner join md_workstation t3 on t2.workstation_id = t3.workstation_id  inner join md_workshop t4 on t4.workshop_id = t3.workshop_id inner join md_factory t5 on t5.factory_id = t4.factory_id   ${ew.customSqlSegment}")
    List<CalWorkunit> selectListByQw(@Param("ew") QueryWrapper<CalWorkunit> query);

    /**
     * 新增计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    int insertCalWorkunit(CalWorkunit calWorkunit);

    /**
     * 修改计划工作单元
     *
     * @param calWorkunit 计划工作单元
     * @return 结果
     */
    int updateCalWorkunit(CalWorkunit calWorkunit);

    /**
     * 删除计划工作单元
     *
     * @param id 计划工作单元主键
     * @return 结果
     */
    int deleteCalWorkunitById(Long id);

    /**
     * 批量删除计划工作单元
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteCalWorkunitByIds(Long[] ids);

    int deleteCalWorkunitByPlanId(Long planId);

    int deleteCalWorkunitByPlanCode(String planCode);
}
