package com.ximai.common.core.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 角色表 sys_role
 *
 */
@Data
@ApiModel("角色导出")
public class SysRoleExcelExport {
    private static final long serialVersionUID = 1L;

    /** 角色名称 */
    @ExcelProperty("角色名称")
    private String roleName;

    /** 角色权限 */
    @ExcelProperty("角色权限")
    private String roleKey;

    /** 角色排序 */
    @ExcelProperty("角色排序")
    private String roleSort;

    /** 数据范围（1：所有数据权限；2：自定义数据权限；3：本部门数据权限；4：本部门及以下数据权限；5：仅本人数据权限） */
    @ExcelProperty("数据范围")
    private String dataScope;

    /** 角色状态（0正常 1停用） */
    @ExcelProperty("角色状态")
    private String status;
}
